/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AisConsentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaLoginToConsentResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralAuthorisationService;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.ConsentRestClient;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import feign.FeignException;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AisConsentSpiImpl
implements AisConsentSpi {
    private static final Logger logger = LoggerFactory.getLogger(AisConsentSpiImpl.class);
    private final ConsentRestClient consentRestClient;
    private final TokenStorageService tokenStorageService;
    private final AisConsentMapper aisConsentMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final ScaMethodConverter scaMethodConverter;
    private final ScaLoginToConsentResponseMapper scaLoginToConsentResponseMapper;

    public AisConsentSpiImpl(ConsentRestClient consentRestClient, TokenStorageService tokenStorageService, AisConsentMapper aisConsentMapper, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, ScaLoginToConsentResponseMapper scaLoginToConsentResponseMapper) {
        this.consentRestClient = consentRestClient;
        this.tokenStorageService = tokenStorageService;
        this.aisConsentMapper = aisConsentMapper;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.scaMethodConverter = scaMethodConverter;
        this.scaLoginToConsentResponseMapper = scaLoginToConsentResponseMapper;
    }

    public SpiResponse<SpiInitiateAisConsentResponse> initiateAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO aisConsentResponse;
        byte[] initialAspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        if (ArrayUtils.isEmpty((byte[])initialAspspConsentData)) {
            return this.firstCallInstantiatingConsent(accountConsent, aspspConsentDataProvider, new SpiInitiateAisConsentResponse());
        }
        try {
            aisConsentResponse = this.initiateConsentInternal(accountConsent, initialAspspConsentData);
        }
        catch (FeignException e) {
            return SpiResponse.builder().error(this.getFailureMessageFromFeignException(e)).build();
        }
        logger.info("SCA status` is {}", (Object)aisConsentResponse.getScaStatus().name());
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)aisConsentResponse));
        return SpiResponse.builder().payload((Object)new SpiInitiateAisConsentResponse(accountConsent.getAccess(), false, "")).build();
    }

    public SpiResponse<SpiResponse.VoidResponse> revokeAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
        sca.setScaStatus(ScaStatusTO.FINALISED);
        sca.setStatusDate(LocalDateTime.now());
        sca.setBearerToken(new BearerTokenTO());
        String scaStatusName = sca.getScaStatus().name();
        logger.info("SCA status` is {}", (Object)scaStatusName);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)sca));
        return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizeConsentResponse = this.consentRestClient.authorizeConsent(sca.getConsentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            SCAConsentResponseTO consentResponse = (SCAConsentResponseTO)authorizeConsentResponse.getBody();
            String scaStatusName = sca.getScaStatus().name();
            logger.info("SCA status` is {}", (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)consentResponse, !consentResponse.isPartiallyAuthorised()));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(this.getConsentStatus(consentResponse))).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuLoginData, String password, SpiAccountConsent aisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO scaConsentResponse;
        SCAConsentResponseTO originalResponse;
        try {
            originalResponse = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class, false);
        }
        catch (FeignException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.TOKEN_UNKNOWN, "Missing credentials. Expecting a bearer token in the consent data object.", new Object[0])).build();
        }
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuLoginData, password, aisConsent.getId(), originalResponse, OpTypeTO.CONSENT, aspspConsentDataProvider);
        if (!authorisePsu.isSuccessful()) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, "authorisation PSU for consent was failed", new Object[0])).build();
        }
        try {
            scaConsentResponse = this.mapToScaConsentResponse(aisConsent, aspspConsentDataProvider.loadAspspConsentData());
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Unknown response type", new Object[0])).build();
        }
        if (EnumSet.of(ScaStatusTO.EXEMPTED, ScaStatusTO.PSUAUTHENTICATED, ScaStatusTO.PSUIDENTIFIED).contains(scaConsentResponse.getScaStatus())) {
            SCAConsentResponseTO aisConsentResponse;
            try {
                aisConsentResponse = this.initiateConsentInternal(aisConsent, aspspConsentDataProvider.loadAspspConsentData());
            }
            catch (FeignException e) {
                return SpiResponse.builder().error(this.getFailureMessageFromFeignException(e)).build();
            }
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)aisConsentResponse));
            return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
        }
        return SpiResponse.builder().payload(authorisePsu.getPayload()).build();
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
            if (sca.getScaMethods() != null) {
                BearerTokenTO bearerTokenTO = this.authorisationService.validateToken(sca.getBearerToken().getAccess_token());
                sca.setBearerToken(bearerTokenTO);
                List scaMethods = sca.getScaMethods();
                List<SpiAuthenticationObject> authenticationObjects = this.scaMethodConverter.toSpiAuthenticationObjectList(scaMethods);
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)sca));
                return SpiResponse.builder().payload(authenticationObjects).build();
            }
            logger.error("Process mismatch. Current SCA Status is %s", (Object)sca.getScaStatus());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SESSIONS_NOT_SUPPORTED, "Process mismatch. Psu doest'n have any sca method", new Object[0])).build();
        }
        catch (FeignException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Getting SCA methods failed", new Object[0])).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SCAConsentResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), SCAConsentResponseTO.class);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                logger.info("Request to generate SCA {}", (Object)sca.getConsentId());
                ResponseEntity selectMethodResponse = this.consentRestClient.selectMethod(sca.getConsentId(), sca.getAuthorisationId(), authenticationMethodId);
                logger.info("SCA was send, operationId is {}", (Object)sca.getConsentId());
                SCAConsentResponseTO authCodeResponse = (SCAConsentResponseTO)selectMethodResponse.getBody();
                if (authCodeResponse != null && authCodeResponse.getBearerToken() == null) {
                    authCodeResponse.setBearerToken(sca.getBearerToken());
                }
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, (SCAResponseTO)authCodeResponse);
                return spiResponse;
            }
            catch (FeignException e) {
                SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_METHOD_UNKNOWN, "Sending SCA via phone not implemented yet", new Object[0])).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, (SCAResponseTO)sca);
    }

    ConsentStatus getConsentStatus(SCAConsentResponseTO consentResponse) {
        if (consentResponse != null && consentResponse.isMultilevelScaRequired() && consentResponse.isPartiallyAuthorised() && ScaStatusTO.FINALISED.equals((Object)consentResponse.getScaStatus())) {
            return ConsentStatus.PARTIALLY_AUTHORISED;
        }
        return ConsentStatus.VALID;
    }

    private <T extends SpiInitiateAisConsentResponse> SpiResponse<T> firstCallInstantiatingConsent(@NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload) {
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setScaStatus(ScaStatusTO.STARTED);
        responsePayload.setAccountAccess(accountConsent.getAccess());
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store((SCAResponseTO)response, false));
        return SpiResponse.builder().payload(responsePayload).build();
    }

    private SCAConsentResponseTO mapToScaConsentResponse(SpiAccountConsent businessObject, byte[] aspspConsentData) throws IOException {
        SCALoginResponseTO scaResponseTO = (SCALoginResponseTO)this.tokenStorageService.fromBytes(aspspConsentData, SCALoginResponseTO.class);
        SCAConsentResponseTO consentResponse = this.scaLoginToConsentResponseMapper.toConsentResponse(scaResponseTO);
        consentResponse.setObjectType(SCAConsentResponseTO.class.getSimpleName());
        consentResponse.setConsentId(businessObject.getId());
        return consentResponse;
    }

    private boolean isEmpty(SpiAccountConsent accountConsent) {
        return !(accountConsent.getAccess() != null && (accountConsent.getAccess().getAccounts() != null && !accountConsent.getAccess().getAccounts().isEmpty() || accountConsent.getAccess().getBalances() != null && !accountConsent.getAccess().getBalances().isEmpty() || accountConsent.getAccess().getTransactions() != null && !accountConsent.getAccess().getTransactions().isEmpty() || accountConsent.getAccess().getAllPsd2() != null || accountConsent.getAccess().getAvailableAccounts() != null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SCAConsentResponseTO initiateConsentInternal(SpiAccountConsent accountConsent, byte[] initialAspspConsentData) throws FeignException {
        try {
            SCAResponseTO sca = this.consentDataService.response(initialAspspConsentData);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            if (this.isEmpty(accountConsent)) {
                accountConsent.getAccess().setAllPsd2(AccountAccessType.ALL_ACCOUNTS);
            }
            AisConsentTO aisConsent = this.aisConsentMapper.toTo(accountConsent);
            ResponseEntity consentResponse = this.consentRestClient.startSCA(accountConsent.getId(), aisConsent);
            SCAConsentResponseTO response = (SCAConsentResponseTO)consentResponse.getBody();
            if (response != null && response.getBearerToken() == null) {
                response.setBearerToken(sca.getBearerToken());
            }
            SCAConsentResponseTO sCAConsentResponseTO = response;
            return sCAConsentResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private TppMessage getFailureMessageFromFeignException(FeignException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return e.status() == 500 ? new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, "Request was failed", new Object[0]) : new TppMessage(MessageErrorCode.FORMAT_ERROR, "Addressed account is unknown to the ASPSP or not associated to the PSU.", new Object[0]);
    }
}

