/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiExchangeRate;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiUsageType;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.List;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public abstract class LedgersSpiAccountMapper {
    public abstract List<SpiAccountDetails> toSpiAccountDetailsList(List<AccountDetailsTO> var1);

    public SpiAccountDetails toSpiAccountDetails(AccountDetailsTO accountDetails) {
        return Optional.ofNullable(accountDetails).map(d -> new SpiAccountDetails(d.getIban(), d.getId(), d.getIban(), d.getBban(), d.getPan(), d.getMaskedPan(), d.getMsisdn(), d.getCurrency(), d.getName(), d.getProduct(), SpiAccountType.valueOf((String)d.getAccountType().name()), SpiAccountStatus.valueOf((String)d.getAccountStatus().name()), d.getBic(), d.getLinkedAccounts(), SpiUsageType.valueOf((String)d.getUsageType().name()), d.getDetails(), this.toSpiAccountBalancesList(d.getBalances()))).orElse(null);
    }

    public abstract List<SpiTransaction> toSpiTransactions(List<TransactionTO> var1);

    public SpiTransaction toSpiTransaction(TransactionTO transaction) {
        return Optional.ofNullable(transaction).map(t -> new SpiTransaction(t.getTransactionId(), t.getEntryReference(), t.getEndToEndId(), t.getMandateId(), t.getCheckId(), t.getCreditorId(), t.getBookingDate(), t.getValueDate(), this.toSpiAmount(t.getAmount()), this.toSpiExchangeRateList(t.getExchangeRate()), t.getCreditorName(), this.toSpiAccountReference(t.getCreditorAccount()), t.getUltimateCreditor(), t.getDebtorName(), this.toSpiAccountReference(t.getDebtorAccount()), t.getUltimateDebtor(), t.getRemittanceInformationUnstructured(), t.getRemittanceInformationStructured(), t.getPurposeCode(), t.getBankTransactionCode(), t.getProprietaryBankTransactionCode())).orElse(null);
    }

    public SpiAccountReference toSpiAccountReference(AccountReferenceTO reference) {
        return Optional.ofNullable(reference).map(r -> new SpiAccountReference(r.getIban(), r.getIban(), r.getIban(), r.getBban(), r.getPan(), r.getMaskedPan(), r.getMsisdn(), r.getCurrency())).orElse(null);
    }

    public abstract List<SpiAccountBalance> toSpiAccountBalancesList(List<AccountBalanceTO> var1);

    @Mappings(value={@Mapping(constant="INTERIM_AVAILABLE", target="spiBalanceType"), @Mapping(source="amount", target="spiBalanceAmount")})
    public abstract SpiAccountBalance accountBalanceTOToSpiAccountBalance(AccountBalanceTO var1);

    public abstract List<SpiExchangeRate> toSpiExchangeRateList(List<ExchangeRateTO> var1);

    public SpiExchangeRate toSpiExchangeRate(ExchangeRateTO exchangeRate) {
        return Optional.ofNullable(exchangeRate).map(e -> new SpiExchangeRate(e.getCurrencyFrom().getCurrencyCode(), e.getRateFrom(), e.getCurrency().getCurrencyCode(), e.getRateTo(), e.getRateDate(), e.getRateContract())).orElse(null);
    }

    public SpiAmount toSpiAmount(AmountTO amount) {
        return Optional.ofNullable(amount).map(a -> new SpiAmount(a.getCurrency(), a.getAmount())).orElse(null);
    }

    public abstract FundsConfirmationRequestTO toFundsConfirmationTO(SpiPsuData var1, SpiFundsConfirmationRequest var2);
}

