/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ChallengeDataMapper;
import de.adorsys.ledgers.middleware.api.domain.sca.ChallengeDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OtpFormatTO;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.OtpFormat;
import java.util.Arrays;
import org.springframework.stereotype.Component;

@Component
public class ChallengeDataMapperImpl
implements ChallengeDataMapper {
    @Override
    public ChallengeData toChallengeData(ChallengeDataTO to) {
        if (to == null) {
            return null;
        }
        ChallengeData challengeData = new ChallengeData();
        byte[] image = to.getImage();
        if (image != null) {
            challengeData.setImage(Arrays.copyOf(image, image.length));
        }
        challengeData.setData(to.getData());
        challengeData.setImageLink(to.getImageLink());
        challengeData.setOtpMaxLength(to.getOtpMaxLength());
        challengeData.setOtpFormat(this.otpFormatTOToOtpFormat(to.getOtpFormat()));
        challengeData.setAdditionalInformation(to.getAdditionalInformation());
        return challengeData;
    }

    protected OtpFormat otpFormatTOToOtpFormat(OtpFormatTO otpFormatTO) {
        OtpFormat otpFormat;
        if (otpFormatTO == null) {
            return null;
        }
        switch (otpFormatTO) {
            case CHARACTERS: {
                otpFormat = OtpFormat.CHARACTERS;
                break;
            }
            case INTEGER: {
                otpFormat = OtpFormat.INTEGER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + otpFormatTO);
            }
        }
        return otpFormat;
    }
}

