/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.PaymentAuthorisationSpiImpl;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentCancellationSpiImpl
implements PaymentCancellationSpi {
    private static final Logger logger = LoggerFactory.getLogger(PaymentCancellationSpiImpl.class);
    private final PaymentRestClient paymentRestClient;
    private final TokenStorageService tokenStorageService;
    private final ScaMethodConverter scaMethodConverter;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final PaymentAuthorisationSpiImpl paymentAuthorisation;

    public PaymentCancellationSpiImpl(PaymentRestClient ledgersRestClient, TokenStorageService tokenStorageService, ScaMethodConverter scaMethodConverter, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, PaymentAuthorisationSpiImpl paymentAuthorisation) {
        this.paymentRestClient = ledgersRestClient;
        this.tokenStorageService = tokenStorageService;
        this.scaMethodConverter = scaMethodConverter;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.paymentAuthorisation = paymentAuthorisation;
    }

    @NotNull
    public SpiResponse<SpiPaymentCancellationResponse> initiatePaymentCancellation(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull AspspConsentData aspspConsentData) {
        SpiPaymentCancellationResponse response = new SpiPaymentCancellationResponse();
        boolean cancellationMandated = payment.getPaymentStatus() != TransactionStatus.RCVD;
        response.setCancellationAuthorisationMandated(cancellationMandated);
        response.setTransactionStatus(payment.getPaymentStatus());
        return SpiResponse.builder().aspspConsentData(aspspConsentData).payload((Object)response).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> cancelPaymentWithoutSca(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull AspspConsentData aspspConsentData) {
        if (payment.getPaymentStatus() == TransactionStatus.RCVD) {
            return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).aspspConsentData(aspspConsentData).build();
        }
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData.getAspspConsentData(), SCAPaymentResponseTO.class);
        if (sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            try {
                this.paymentRestClient.initiatePmtCancellation(payment.getPaymentId());
                return SpiResponse.builder().aspspConsentData(aspspConsentData).payload((Object)SpiResponse.voidResponse()).build();
            }
            catch (FeignException f) {
                logger.error("An error occured during Payment Cancellation Process: {}, with message: {}", (Object)f.status(), (Object)f.getLocalizedMessage());
                return SpiResponse.builder().aspspConsentData(aspspConsentData).error(this.getFailureMessageFromFeignException(f)).build();
            }
        }
        return SpiResponse.builder().aspspConsentData(aspspConsentData).error(new TppMessage(MessageErrorCode.CANCELLATION_INVALID, "Couldn't execute payment cancellation", new Object[0])).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndCancelPayment(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPayment payment, @NotNull AspspConsentData aspspConsentData) {
        try {
            SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData.getAspspConsentData(), SCAPaymentResponseTO.class);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity response = this.paymentRestClient.authorizeCancelPayment(sca.getPaymentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            return response.getStatusCode() == HttpStatus.OK ? SpiResponse.builder().aspspConsentData(aspspConsentData).payload((Object)SpiResponse.voidResponse()).build() : SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Couldn't authorise payment cancellation", new Object[0])).build();
        }
        catch (Exception e) {
            return SpiResponse.builder().aspspConsentData(aspspConsentData).error(new TppMessage(MessageErrorCode.FORMAT_ERROR, "Couldn't execute authorisation payment cancellation", new Object[0])).build();
        }
    }

    public SpiResponse<SpiAuthorisationStatus> authorisePsu(@NotNull SpiContextData contextData, @NotNull SpiPsuData psuData, String password, SpiPayment businessObject, @NotNull AspspConsentData aspspConsentData) {
        SCAPaymentResponseTO originalResponse = this.consentDataService.response(aspspConsentData.getAspspConsentData(), SCAPaymentResponseTO.class, false);
        SpiResponse<SpiAuthorisationStatus> authorisePsu = this.authorisationService.authorisePsuForConsent(psuData, password, businessObject.getPaymentId(), originalResponse, OpTypeTO.CANCEL_PAYMENT, aspspConsentData);
        if (!authorisePsu.isSuccessful()) {
            return authorisePsu;
        }
        try {
            SCAPaymentResponseTO scaPaymentResponse = this.paymentAuthorisation.toPaymentConsent(businessObject, authorisePsu, originalResponse);
            AspspConsentData paymentAspspConsentData = authorisePsu.getAspspConsentData().respondWith(this.tokenStorageService.toBytes((SCAResponseTO)scaPaymentResponse));
            return SpiResponse.builder().payload((Object)SpiAuthorisationStatus.SUCCESS).aspspConsentData(paymentAspspConsentData).build();
        }
        catch (IOException e) {
            return SpiResponse.builder().aspspConsentData(aspspConsentData).error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Couldn't authorise payment cancellation", new Object[0])).build();
        }
    }

    public SpiResponse<List<SpiAuthenticationObject>> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiPayment businessObject, @NotNull AspspConsentData aspspConsentData) {
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData.getAspspConsentData(), SCAPaymentResponseTO.class);
        if (businessObject.getPaymentStatus() == TransactionStatus.RCVD || sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            return SpiResponse.builder().payload(Collections.emptyList()).aspspConsentData(aspspConsentData).build();
        }
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        ResponseEntity cancelSCA = this.paymentRestClient.getCancelSCA(sca.getPaymentId(), sca.getAuthorisationId());
        List authenticationObjectList = Optional.ofNullable(cancelSCA.getBody()).map(SCAResponseTO::getScaMethods).map(this.scaMethodConverter::toSpiAuthenticationObjectList).orElseGet(Collections::emptyList);
        return authenticationObjectList.isEmpty() ? SpiResponse.builder().aspspConsentData(aspspConsentData).error(new TppMessage(MessageErrorCode.UNAUTHORIZED, "Getting SCA methods failed", new Object[0])).build() : SpiResponse.builder().payload((Object)authenticationObjectList).aspspConsentData(aspspConsentData).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull SpiPayment businessObject, @NotNull AspspConsentData aspspConsentData) {
        SCAPaymentResponseTO sca = this.consentDataService.response(aspspConsentData.getAspspConsentData(), SCAPaymentResponseTO.class);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                logger.info("Request to generate SCA {}", (Object)sca.getPaymentId());
                ResponseEntity selectMethodResponse = this.paymentRestClient.selecCancelPaymentSCAtMethod(sca.getPaymentId(), sca.getAuthorisationId(), authenticationMethodId);
                logger.info("SCA was send, operationId is {}", (Object)sca.getPaymentId());
                sca = (SCAPaymentResponseTO)selectMethodResponse.getBody();
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentData, (SCAResponseTO)sca);
                return spiResponse;
            }
            catch (FeignException e) {
                SpiResponse spiResponse = SpiResponse.builder().aspspConsentData(aspspConsentData).error(this.getFailureMessageFromFeignException(e)).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentData, (SCAResponseTO)sca);
    }

    private TppMessage getFailureMessageFromFeignException(FeignException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return e.status() == 500 ? new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, "Request was failed", new Object[0]) : new TppMessage(MessageErrorCode.FORMAT_ERROR, "Couldn't execute payment cancellation", new Object[0]);
    }
}

