/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapperHelper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ChallengeDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.code.SpiFrequencyCode;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class LedgersSpiPaymentMapperImpl
extends LedgersSpiPaymentMapper {
    @Override
    public SinglePaymentTO toSinglePaymentTO(SpiSinglePayment payment) {
        if (payment == null) {
            return null;
        }
        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();
        singlePaymentTO.setPaymentId(payment.getPaymentId());
        singlePaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        singlePaymentTO.setDebtorAccount(this.spiAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        singlePaymentTO.setInstructedAmount(this.spiAmountToAmountTO(payment.getInstructedAmount()));
        singlePaymentTO.setCreditorAccount(this.spiAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        singlePaymentTO.setCreditorAgent(payment.getCreditorAgent());
        singlePaymentTO.setCreditorName(payment.getCreditorName());
        singlePaymentTO.setCreditorAddress(this.spiAddressToAddressTO(payment.getCreditorAddress()));
        singlePaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        singlePaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        singlePaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        singlePaymentTO.setPaymentProduct(this.toPaymentProduct(payment.getPaymentProduct()));
        singlePaymentTO.setRequestedExecutionTime(this.toTime(payment.getRequestedExecutionTime()));
        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPeriodicPaymentTO(SpiPeriodicPayment payment) {
        if (payment == null) {
            return null;
        }
        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();
        periodicPaymentTO.setPaymentId(payment.getPaymentId());
        periodicPaymentTO.setEndToEndIdentification(payment.getEndToEndIdentification());
        periodicPaymentTO.setDebtorAccount(this.spiAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        periodicPaymentTO.setInstructedAmount(this.spiAmountToAmountTO(payment.getInstructedAmount()));
        periodicPaymentTO.setCreditorAccount(this.spiAccountReferenceToAccountReferenceTO(payment.getCreditorAccount()));
        periodicPaymentTO.setCreditorAgent(payment.getCreditorAgent());
        periodicPaymentTO.setCreditorName(payment.getCreditorName());
        periodicPaymentTO.setCreditorAddress(this.spiAddressToAddressTO(payment.getCreditorAddress()));
        periodicPaymentTO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        periodicPaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        periodicPaymentTO.setPaymentProduct(this.toPaymentProduct(payment.getPaymentProduct()));
        periodicPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        periodicPaymentTO.setRequestedExecutionTime(this.toTime(payment.getRequestedExecutionTime()));
        periodicPaymentTO.setStartDate(payment.getStartDate());
        periodicPaymentTO.setEndDate(payment.getEndDate());
        periodicPaymentTO.setFrequency(this.spiFrequencyCodeToFrequencyCodeTO(payment.getFrequency()));
        periodicPaymentTO.setExecutionRule(LedgersSpiPaymentMapperHelper.mapPisExecutionRule(payment.getExecutionRule()));
        periodicPaymentTO.setDayOfExecution(Integer.valueOf(LedgersSpiPaymentMapperHelper.mapPisDayOfExecution(payment.getDayOfExecution())));
        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toBulkPaymentTO(SpiBulkPayment payment) {
        if (payment == null) {
            return null;
        }
        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();
        bulkPaymentTO.setPaymentId(payment.getPaymentId());
        bulkPaymentTO.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        bulkPaymentTO.setDebtorAccount(this.spiAccountReferenceToAccountReferenceTO(payment.getDebtorAccount()));
        bulkPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        bulkPaymentTO.setPaymentStatus(this.transactionStatusToTransactionStatusTO(payment.getPaymentStatus()));
        bulkPaymentTO.setPayments(this.spiSinglePaymentListToSinglePaymentTOList(payment.getPayments()));
        bulkPaymentTO.setPaymentProduct(this.toPaymentProduct(payment.getPaymentProduct()));
        return bulkPaymentTO;
    }

    @Override
    public SpiSinglePaymentInitiationResponse toSpiSingleResponse(SinglePaymentTO payment) {
        if (payment == null) {
            return null;
        }
        SpiSinglePaymentInitiationResponse spiSinglePaymentInitiationResponse = new SpiSinglePaymentInitiationResponse();
        spiSinglePaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(payment.getPaymentStatus()));
        spiSinglePaymentInitiationResponse.setPaymentId(payment.getPaymentId());
        return spiSinglePaymentInitiationResponse;
    }

    @Override
    public SpiSinglePaymentInitiationResponse toSpiSingleResponse(SCAPaymentResponseTO response) {
        if (response == null) {
            return null;
        }
        SpiSinglePaymentInitiationResponse spiSinglePaymentInitiationResponse = new SpiSinglePaymentInitiationResponse();
        spiSinglePaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(response.getTransactionStatus()));
        spiSinglePaymentInitiationResponse.setPaymentId(response.getPaymentId());
        spiSinglePaymentInitiationResponse.setMultilevelScaRequired(response.isMultilevelScaRequired());
        spiSinglePaymentInitiationResponse.setChallengeData(this.challengeDataTOToChallengeData(response.getChallengeData()));
        spiSinglePaymentInitiationResponse.setPsuMessage(response.getPsuMessage());
        spiSinglePaymentInitiationResponse.setChosenScaMethod(ScaMethodUtils.toScaMethod(response.getChosenScaMethod()));
        spiSinglePaymentInitiationResponse.setScaMethods(ScaMethodUtils.toScaMethods(response.getScaMethods()));
        return spiSinglePaymentInitiationResponse;
    }

    @Override
    public SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(PeriodicPaymentTO payment) {
        if (payment == null) {
            return null;
        }
        SpiPeriodicPaymentInitiationResponse spiPeriodicPaymentInitiationResponse = new SpiPeriodicPaymentInitiationResponse();
        spiPeriodicPaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(payment.getPaymentStatus()));
        spiPeriodicPaymentInitiationResponse.setPaymentId(payment.getPaymentId());
        return spiPeriodicPaymentInitiationResponse;
    }

    @Override
    public SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(SCAPaymentResponseTO response) {
        if (response == null) {
            return null;
        }
        SpiPeriodicPaymentInitiationResponse spiPeriodicPaymentInitiationResponse = new SpiPeriodicPaymentInitiationResponse();
        spiPeriodicPaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(response.getTransactionStatus()));
        spiPeriodicPaymentInitiationResponse.setPaymentId(response.getPaymentId());
        spiPeriodicPaymentInitiationResponse.setMultilevelScaRequired(response.isMultilevelScaRequired());
        spiPeriodicPaymentInitiationResponse.setChallengeData(this.challengeDataTOToChallengeData(response.getChallengeData()));
        spiPeriodicPaymentInitiationResponse.setPsuMessage(response.getPsuMessage());
        spiPeriodicPaymentInitiationResponse.setChosenScaMethod(ScaMethodUtils.toScaMethod(response.getChosenScaMethod()));
        spiPeriodicPaymentInitiationResponse.setScaMethods(ScaMethodUtils.toScaMethods(response.getScaMethods()));
        return spiPeriodicPaymentInitiationResponse;
    }

    @Override
    public SpiBulkPaymentInitiationResponse toSpiBulkResponse(BulkPaymentTO payment) {
        if (payment == null) {
            return null;
        }
        SpiBulkPaymentInitiationResponse spiBulkPaymentInitiationResponse = new SpiBulkPaymentInitiationResponse();
        spiBulkPaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(payment.getPaymentStatus()));
        spiBulkPaymentInitiationResponse.setPaymentId(payment.getPaymentId());
        spiBulkPaymentInitiationResponse.setPayments(this.toSpiSinglePaymentsList(payment.getPayments()));
        return spiBulkPaymentInitiationResponse;
    }

    @Override
    public SpiBulkPaymentInitiationResponse toSpiBulkResponse(SCAPaymentResponseTO response) {
        if (response == null) {
            return null;
        }
        SpiBulkPaymentInitiationResponse spiBulkPaymentInitiationResponse = new SpiBulkPaymentInitiationResponse();
        spiBulkPaymentInitiationResponse.setTransactionStatus(this.transactionStatusTOToTransactionStatus(response.getTransactionStatus()));
        spiBulkPaymentInitiationResponse.setPaymentId(response.getPaymentId());
        spiBulkPaymentInitiationResponse.setMultilevelScaRequired(response.isMultilevelScaRequired());
        spiBulkPaymentInitiationResponse.setChallengeData(this.challengeDataTOToChallengeData(response.getChallengeData()));
        spiBulkPaymentInitiationResponse.setPsuMessage(response.getPsuMessage());
        spiBulkPaymentInitiationResponse.setChosenScaMethod(ScaMethodUtils.toScaMethod(response.getChosenScaMethod()));
        spiBulkPaymentInitiationResponse.setScaMethods(ScaMethodUtils.toScaMethods(response.getScaMethods()));
        return spiBulkPaymentInitiationResponse;
    }

    @Override
    public List<SpiSinglePayment> toSpiSinglePaymentsList(List<SinglePaymentTO> payments) {
        if (payments == null) {
            return null;
        }
        ArrayList<SpiSinglePayment> list = new ArrayList<SpiSinglePayment>(payments.size());
        for (SinglePaymentTO singlePaymentTO : payments) {
            list.add(this.toSpiSinglePayment(singlePaymentTO));
        }
        return list;
    }

    protected AccountReferenceTO spiAccountReferenceToAccountReferenceTO(SpiAccountReference spiAccountReference) {
        if (spiAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(spiAccountReference.getIban());
        accountReferenceTO.setBban(spiAccountReference.getBban());
        accountReferenceTO.setPan(spiAccountReference.getPan());
        accountReferenceTO.setMaskedPan(spiAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(spiAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(spiAccountReference.getCurrency());
        return accountReferenceTO;
    }

    protected AmountTO spiAmountToAmountTO(SpiAmount spiAmount) {
        if (spiAmount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(spiAmount.getCurrency());
        amountTO.setAmount(spiAmount.getAmount());
        return amountTO;
    }

    protected AddressTO spiAddressToAddressTO(SpiAddress spiAddress) {
        if (spiAddress == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(spiAddress.getStreet());
        addressTO.setBuildingNumber(spiAddress.getBuildingNumber());
        addressTO.setCity(spiAddress.getCity());
        addressTO.setPostalCode(spiAddress.getPostalCode());
        addressTO.setCountry(spiAddress.getCountry());
        return addressTO;
    }

    protected TransactionStatusTO transactionStatusToTransactionStatusTO(TransactionStatus transactionStatus) {
        TransactionStatusTO transactionStatusTO;
        if (transactionStatus == null) {
            return null;
        }
        switch (transactionStatus) {
            case ACCC: {
                transactionStatusTO = TransactionStatusTO.ACCC;
                break;
            }
            case ACCP: {
                transactionStatusTO = TransactionStatusTO.ACCP;
                break;
            }
            case ACSC: {
                transactionStatusTO = TransactionStatusTO.ACSC;
                break;
            }
            case ACSP: {
                transactionStatusTO = TransactionStatusTO.ACSP;
                break;
            }
            case ACTC: {
                transactionStatusTO = TransactionStatusTO.ACTC;
                break;
            }
            case ACWC: {
                transactionStatusTO = TransactionStatusTO.ACWC;
                break;
            }
            case ACWP: {
                transactionStatusTO = TransactionStatusTO.ACWP;
                break;
            }
            case RCVD: {
                transactionStatusTO = TransactionStatusTO.RCVD;
                break;
            }
            case PDNG: {
                transactionStatusTO = TransactionStatusTO.PDNG;
                break;
            }
            case RJCT: {
                transactionStatusTO = TransactionStatusTO.RJCT;
                break;
            }
            case CANC: {
                transactionStatusTO = TransactionStatusTO.CANC;
                break;
            }
            case ACFC: {
                transactionStatusTO = TransactionStatusTO.ACFC;
                break;
            }
            case PATC: {
                transactionStatusTO = TransactionStatusTO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatus);
            }
        }
        return transactionStatusTO;
    }

    protected FrequencyCodeTO spiFrequencyCodeToFrequencyCodeTO(SpiFrequencyCode spiFrequencyCode) {
        FrequencyCodeTO frequencyCodeTO;
        if (spiFrequencyCode == null) {
            return null;
        }
        switch (spiFrequencyCode) {
            case DAILY: {
                frequencyCodeTO = FrequencyCodeTO.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCodeTO = FrequencyCodeTO.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCodeTO = FrequencyCodeTO.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + spiFrequencyCode);
            }
        }
        return frequencyCodeTO;
    }

    protected List<SinglePaymentTO> spiSinglePaymentListToSinglePaymentTOList(List<SpiSinglePayment> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SinglePaymentTO> list1 = new ArrayList<SinglePaymentTO>(list.size());
        for (SpiSinglePayment spiSinglePayment : list) {
            list1.add(this.toSinglePaymentTO(spiSinglePayment));
        }
        return list1;
    }

    protected TransactionStatus transactionStatusTOToTransactionStatus(TransactionStatusTO transactionStatusTO) {
        TransactionStatus transactionStatus;
        if (transactionStatusTO == null) {
            return null;
        }
        switch (transactionStatusTO) {
            case ACCC: {
                transactionStatus = TransactionStatus.ACCC;
                break;
            }
            case ACCP: {
                transactionStatus = TransactionStatus.ACCP;
                break;
            }
            case ACSC: {
                transactionStatus = TransactionStatus.ACSC;
                break;
            }
            case ACSP: {
                transactionStatus = TransactionStatus.ACSP;
                break;
            }
            case ACTC: {
                transactionStatus = TransactionStatus.ACTC;
                break;
            }
            case ACWC: {
                transactionStatus = TransactionStatus.ACWC;
                break;
            }
            case ACWP: {
                transactionStatus = TransactionStatus.ACWP;
                break;
            }
            case RCVD: {
                transactionStatus = TransactionStatus.RCVD;
                break;
            }
            case PDNG: {
                transactionStatus = TransactionStatus.PDNG;
                break;
            }
            case RJCT: {
                transactionStatus = TransactionStatus.RJCT;
                break;
            }
            case CANC: {
                transactionStatus = TransactionStatus.CANC;
                break;
            }
            case ACFC: {
                transactionStatus = TransactionStatus.ACFC;
                break;
            }
            case PATC: {
                transactionStatus = TransactionStatus.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatusTO);
            }
        }
        return transactionStatus;
    }

    protected ChallengeData challengeDataTOToChallengeData(ChallengeDataTO challengeDataTO) {
        if (challengeDataTO == null) {
            return null;
        }
        ChallengeData challengeData = new ChallengeData();
        return challengeData;
    }
}

