/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.code.SpiFrequencyCode;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring", uses={LedgersSpiAccountMapper.class})
public abstract class LedgersSpiPaymentMapper {
    private LedgersSpiAccountMapper accountMapper = (LedgersSpiAccountMapper)Mappers.getMapper(LedgersSpiAccountMapper.class);

    @Mappings(value={@Mapping(target="requestedExecutionTime", expression="java(toTime(payment.getRequestedExecutionTime()))"), @Mapping(target="paymentProduct", expression="java(toPaymentProduct(payment.getPaymentProduct()))")})
    public abstract SinglePaymentTO toSinglePaymentTO(SpiSinglePayment var1);

    @Mappings(value={@Mapping(target="executionRule", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapperHelper.mapPisExecutionRule(payment.getExecutionRule()))"), @Mapping(target="dayOfExecution", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentMapperHelper.mapPisDayOfExecution(payment.getDayOfExecution()))")})
    public abstract PeriodicPaymentTO toPeriodicPaymentTO(SpiPeriodicPayment var1);

    public abstract BulkPaymentTO toBulkPaymentTO(SpiBulkPayment var1);

    @Mapping(source="paymentStatus", target="transactionStatus")
    public abstract SpiSinglePaymentInitiationResponse toSpiSingleResponse(SinglePaymentTO var1);

    @Mappings(value={@Mapping(target="scaMethods", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethods(response.getScaMethods()))"), @Mapping(target="chosenScaMethod", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethod(response.getChosenScaMethod()))")})
    public abstract SpiSinglePaymentInitiationResponse toSpiSingleResponse(SCAPaymentResponseTO var1);

    @Mapping(source="paymentStatus", target="transactionStatus")
    public abstract SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(PeriodicPaymentTO var1);

    @Mappings(value={@Mapping(target="scaMethods", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethods(response.getScaMethods()))"), @Mapping(target="chosenScaMethod", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethod(response.getChosenScaMethod()))")})
    public abstract SpiPeriodicPaymentInitiationResponse toSpiPeriodicResponse(SCAPaymentResponseTO var1);

    @Mapping(source="paymentStatus", target="transactionStatus")
    public abstract SpiBulkPaymentInitiationResponse toSpiBulkResponse(BulkPaymentTO var1);

    @Mappings(value={@Mapping(target="scaMethods", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethods(response.getScaMethods()))"), @Mapping(target="chosenScaMethod", expression="java(de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodUtils.toScaMethod(response.getChosenScaMethod()))")})
    public abstract SpiBulkPaymentInitiationResponse toSpiBulkResponse(SCAPaymentResponseTO var1);

    public SpiSinglePayment toSpiSinglePayment(SinglePaymentTO payment) {
        SpiSinglePayment spiPayment = new SpiSinglePayment(payment.getPaymentProduct().getValue());
        spiPayment.setPaymentId(payment.getPaymentId());
        spiPayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        spiPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(payment.getDebtorAccount()));
        spiPayment.setInstructedAmount(this.accountMapper.toSpiAmount(payment.getInstructedAmount()));
        spiPayment.setCreditorAccount(this.accountMapper.toSpiAccountReference(payment.getCreditorAccount()));
        spiPayment.setCreditorAgent(payment.getCreditorAgent());
        spiPayment.setCreditorName(payment.getCreditorName());
        spiPayment.setCreditorAddress(this.toSpiAddress(payment.getCreditorAddress()));
        spiPayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        spiPayment.setPaymentStatus(TransactionStatus.valueOf((String)payment.getPaymentStatus().name()));
        spiPayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        spiPayment.setRequestedExecutionTime((OffsetDateTime)Optional.ofNullable(payment.getRequestedExecutionDate()).map(d -> this.toDateTime((LocalDate)d, payment.getRequestedExecutionTime())).orElse(null));
        return spiPayment;
    }

    public SpiPeriodicPayment mapToSpiPeriodicPayment(PeriodicPaymentTO payment) {
        SpiPeriodicPayment spiPayment = new SpiPeriodicPayment(payment.getPaymentProduct().getValue());
        spiPayment.setPaymentId(payment.getPaymentId());
        spiPayment.setEndToEndIdentification(payment.getEndToEndIdentification());
        spiPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(payment.getDebtorAccount()));
        spiPayment.setInstructedAmount(this.accountMapper.toSpiAmount(payment.getInstructedAmount()));
        spiPayment.setCreditorAccount(this.accountMapper.toSpiAccountReference(payment.getCreditorAccount()));
        spiPayment.setCreditorAgent(payment.getCreditorAgent());
        spiPayment.setCreditorName(payment.getCreditorName());
        spiPayment.setCreditorAddress(this.toSpiAddress(payment.getCreditorAddress()));
        spiPayment.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        spiPayment.setPaymentStatus(TransactionStatus.valueOf((String)payment.getPaymentStatus().name()));
        spiPayment.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        spiPayment.setRequestedExecutionTime(this.toDateTime(payment.getRequestedExecutionDate(), payment.getRequestedExecutionTime()));
        spiPayment.setStartDate(payment.getStartDate());
        spiPayment.setEndDate(payment.getEndDate());
        spiPayment.setExecutionRule(PisExecutionRule.valueOf((String)payment.getExecutionRule()));
        spiPayment.setFrequency(SpiFrequencyCode.valueOf((String)payment.getFrequency().name()));
        spiPayment.setDayOfExecution(PisDayOfExecution.valueOf((String)("" + payment.getDayOfExecution())));
        return spiPayment;
    }

    public SpiBulkPayment mapToSpiBulkPayment(BulkPaymentTO payment) {
        return Optional.ofNullable(payment).map(p -> {
            SpiBulkPayment spiBulkPayment = new SpiBulkPayment();
            spiBulkPayment.setPaymentId(p.getPaymentId());
            spiBulkPayment.setBatchBookingPreferred(p.getBatchBookingPreferred());
            spiBulkPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(p.getDebtorAccount()));
            spiBulkPayment.setRequestedExecutionDate(p.getRequestedExecutionDate());
            spiBulkPayment.setPaymentStatus(TransactionStatus.valueOf((String)p.getPaymentStatus().name()));
            spiBulkPayment.setPayments(this.toSpiSinglePaymentsList(p.getPayments()));
            spiBulkPayment.setPaymentProduct(p.getPaymentProduct().getValue());
            return spiBulkPayment;
        }).orElse(null);
    }

    public abstract List<SpiSinglePayment> toSpiSinglePaymentsList(List<SinglePaymentTO> var1);

    public LocalTime toTime(OffsetDateTime time) {
        return Optional.ofNullable(time).map(OffsetDateTime::toLocalTime).orElse(null);
    }

    public OffsetDateTime toDateTime(LocalDate date, LocalTime time) {
        return Optional.ofNullable(date).map(d -> LocalDateTime.of(d, Optional.ofNullable(time).orElse(LocalTime.ofSecondOfDay(0L))).atOffset(ZoneOffset.UTC)).orElse(null);
    }

    private SpiAddress toSpiAddress(AddressTO address) {
        return Optional.ofNullable(address).map(a -> new SpiAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), a.getCountry())).orElse(null);
    }

    public SpiPaymentCancellationResponse toSpiPaymentCancellationResponse(SCAPaymentResponseTO response) {
        return Optional.ofNullable(response).map(t -> {
            SpiPaymentCancellationResponse cancellation = new SpiPaymentCancellationResponse();
            cancellation.setCancellationAuthorisationMandated(this.needAuthorization(response));
            cancellation.setTransactionStatus(TransactionStatus.valueOf((String)response.getTransactionStatus().name()));
            return cancellation;
        }).orElseGet(SpiPaymentCancellationResponse::new);
    }

    PaymentProductTO toPaymentProduct(String paymentProduct) {
        if (paymentProduct == null) {
            return null;
        }
        return PaymentProductTO.getByValue((String)paymentProduct).orElse(null);
    }

    private boolean needAuthorization(SCAPaymentResponseTO response) {
        return !ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus());
    }
}

