/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AisConsentMapper;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AisConsentMapperImpl
extends AisConsentMapper {
    @Override
    public AisConsentTO toTo(SpiAccountConsent consent) {
        if (consent == null) {
            return null;
        }
        AisConsentTO aisConsentTO = new AisConsentTO();
        String authorisationNumber = this.consentTppInfoAuthorisationNumber(consent);
        if (authorisationNumber != null) {
            aisConsentTO.setTppId(authorisationNumber);
        }
        aisConsentTO.setId(consent.getId());
        aisConsentTO.setFrequencyPerDay(consent.getFrequencyPerDay());
        aisConsentTO.setAccess(this.spiAccountAccessToAisAccountAccessInfoTO(consent.getAccess()));
        aisConsentTO.setValidUntil(consent.getValidUntil());
        aisConsentTO.setRecurringIndicator(consent.isRecurringIndicator());
        return aisConsentTO;
    }

    private String consentTppInfoAuthorisationNumber(SpiAccountConsent spiAccountConsent) {
        if (spiAccountConsent == null) {
            return null;
        }
        TppInfo tppInfo = spiAccountConsent.getTppInfo();
        if (tppInfo == null) {
            return null;
        }
        String authorisationNumber = tppInfo.getAuthorisationNumber();
        if (authorisationNumber == null) {
            return null;
        }
        return authorisationNumber;
    }

    protected List<String> spiAccountReferenceListToStringList(List<SpiAccountReference> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> list1 = new ArrayList<String>(list.size());
        for (SpiAccountReference spiAccountReference : list) {
            list1.add(this.mapSpiAccountReferenceToString(spiAccountReference));
        }
        return list1;
    }

    protected AisAccountAccessTypeTO accountAccessTypeToAisAccountAccessTypeTO(AccountAccessType accountAccessType) {
        AisAccountAccessTypeTO aisAccountAccessTypeTO;
        if (accountAccessType == null) {
            return null;
        }
        switch (accountAccessType) {
            case ALL_ACCOUNTS: {
                aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS;
                break;
            }
            case ALL_ACCOUNTS_WITH_BALANCES: {
                aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountAccessType);
            }
        }
        return aisAccountAccessTypeTO;
    }

    protected AisAccountAccessInfoTO spiAccountAccessToAisAccountAccessInfoTO(SpiAccountAccess spiAccountAccess) {
        if (spiAccountAccess == null) {
            return null;
        }
        AisAccountAccessInfoTO aisAccountAccessInfoTO = new AisAccountAccessInfoTO();
        aisAccountAccessInfoTO.setAccounts(this.spiAccountReferenceListToStringList(spiAccountAccess.getAccounts()));
        aisAccountAccessInfoTO.setBalances(this.spiAccountReferenceListToStringList(spiAccountAccess.getBalances()));
        aisAccountAccessInfoTO.setTransactions(this.spiAccountReferenceListToStringList(spiAccountAccess.getTransactions()));
        aisAccountAccessInfoTO.setAvailableAccounts(this.accountAccessTypeToAisAccountAccessTypeTO(spiAccountAccess.getAvailableAccounts()));
        aisAccountAccessInfoTO.setAllPsd2(this.accountAccessTypeToAisAccountAccessTypeTO(spiAccountAccess.getAllPsd2()));
        return aisAccountAccessInfoTO;
    }
}

