/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment;

import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.GeneralPaymentService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.NotSupportedPaymentTypeException;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.PaymentSpi;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiBulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class PaymentSpiImpl
implements PaymentSpi {
    protected final GeneralPaymentService paymentService;

    @Override
    public <P extends SpiPayment> SpiResponse<? extends SpiPaymentInitiationResponse> initiatePayment(@NotNull SpiContextData contextData, @NotNull P spiPayment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) throws NotSupportedPaymentTypeException {
        PaymentType paymentType = spiPayment.getPaymentType();
        SpiPsuData spiPsuData = contextData.getPsuData();
        switch (paymentType) {
            case SINGLE: {
                SpiSinglePayment singlePayment = (SpiSinglePayment)spiPayment;
                HashSet<SpiAccountReference> spiAccountReferences = new HashSet<SpiAccountReference>(Collections.singleton(singlePayment.getDebtorAccount()));
                return this.paymentService.firstCallInstantiatingPayment(PaymentTypeTO.SINGLE, (SpiPayment)singlePayment, aspspConsentDataProvider, new SpiSinglePaymentInitiationResponse(), spiPsuData, spiAccountReferences);
            }
            case BULK: {
                SpiBulkPayment bulkPayment = (SpiBulkPayment)spiPayment;
                Set<SpiAccountReference> spiAccountReferences = bulkPayment.getPayments().stream().map(SpiSinglePayment::getDebtorAccount).collect(Collectors.toSet());
                return this.paymentService.firstCallInstantiatingPayment(PaymentTypeTO.BULK, (SpiPayment)bulkPayment, aspspConsentDataProvider, new SpiBulkPaymentInitiationResponse(), spiPsuData, spiAccountReferences);
            }
            case PERIODIC: {
                SpiPeriodicPayment periodicPayment = (SpiPeriodicPayment)spiPayment;
                HashSet<SpiAccountReference> spiAccountReferences = new HashSet<SpiAccountReference>(Collections.singleton(periodicPayment.getDebtorAccount()));
                return this.paymentService.firstCallInstantiatingPayment(PaymentTypeTO.PERIODIC, (SpiPayment)periodicPayment, aspspConsentDataProvider, new SpiPeriodicPaymentInitiationResponse(), spiPsuData, spiAccountReferences);
            }
        }
        throw new NotSupportedPaymentTypeException(String.format("Unknown payment type: %s", paymentType.getValue()));
    }

    public PaymentSpiImpl(GeneralPaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

