/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthProfileServiceWrapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.AuthConfirmationCodeServiceImpl;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.PaymentAuthConfirmationCodeService;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PaymentAuthConfirmationCodeServiceImpl
extends AuthConfirmationCodeServiceImpl<SpiPaymentConfirmationCodeValidationResponse>
implements PaymentAuthConfirmationCodeService {
    public PaymentAuthConfirmationCodeServiceImpl(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, UserMgmtRestClient userMgmtRestClient, OauthProfileServiceWrapper oauthProfileServiceWrapper) {
        super(authRequestInterceptor, consentDataService, feignExceptionReader, userMgmtRestClient, oauthProfileServiceWrapper);
    }

    @Override
    protected SpiResponse<SpiPaymentConfirmationCodeValidationResponse> handleAuthConfirmationResponse(ResponseEntity<AuthConfirmationTO> authConfirmationResponse) {
        AuthConfirmationTO authConfirmationTO = (AuthConfirmationTO)authConfirmationResponse.getBody();
        if (authConfirmationTO == null || !authConfirmationTO.isSuccess()) {
            return this.buildFailedConfirmationCodeResponse();
        }
        if (authConfirmationTO.isPartiallyAuthorised()) {
            return this.getConfirmationCodeResponseForXs2a(ScaStatus.FINALISED, TransactionStatus.PATC);
        }
        Optional<TransactionStatus> xs2aTransactionStatus = Optional.ofNullable(authConfirmationTO.getTransactionStatus()).map(TransactionStatusTO::getName).map(TransactionStatus::getByValue);
        return xs2aTransactionStatus.map(transactionStatus -> this.getConfirmationCodeResponseForXs2a(ScaStatus.FINALISED, (TransactionStatus)transactionStatus)).orElse(this.buildFailedConfirmationCodeResponse());
    }

    private SpiResponse<SpiPaymentConfirmationCodeValidationResponse> getConfirmationCodeResponseForXs2a(ScaStatus scaStatus, TransactionStatus transactionStatus) {
        SpiPaymentConfirmationCodeValidationResponse response = new SpiPaymentConfirmationCodeValidationResponse(scaStatus, transactionStatus);
        return SpiResponse.builder().payload((Object)response).build();
    }

    private SpiResponse<SpiPaymentConfirmationCodeValidationResponse> buildFailedConfirmationCodeResponse() {
        return this.getConfirmationCodeResponseForXs2a(ScaStatus.FAILED, TransactionStatus.RJCT);
    }
}

