/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthProfileServiceWrapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.AuthConfirmationCodeServiceImpl;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.ConsentAuthConfirmationCodeService;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class ConsentAuthConfirmationCodeServiceImpl
extends AuthConfirmationCodeServiceImpl<SpiConsentConfirmationCodeValidationResponse>
implements ConsentAuthConfirmationCodeService {
    public ConsentAuthConfirmationCodeServiceImpl(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, UserMgmtRestClient userMgmtRestClient, OauthProfileServiceWrapper oauthProfileServiceWrapper) {
        super(authRequestInterceptor, consentDataService, feignExceptionReader, userMgmtRestClient, oauthProfileServiceWrapper);
    }

    @Override
    protected SpiResponse<SpiConsentConfirmationCodeValidationResponse> handleAuthConfirmationResponse(ResponseEntity<AuthConfirmationTO> authConfirmationResponse) {
        AuthConfirmationTO authConfirmationTO = (AuthConfirmationTO)authConfirmationResponse.getBody();
        if (authConfirmationTO == null || !authConfirmationTO.isSuccess()) {
            return this.getConfirmationCodeResponseForXs2a(ScaStatus.FAILED, ConsentStatus.REJECTED);
        }
        if (authConfirmationTO.isPartiallyAuthorised()) {
            return this.getConfirmationCodeResponseForXs2a(ScaStatus.FINALISED, ConsentStatus.PARTIALLY_AUTHORISED);
        }
        return this.getConfirmationCodeResponseForXs2a(ScaStatus.FINALISED, ConsentStatus.VALID);
    }

    private SpiResponse<SpiConsentConfirmationCodeValidationResponse> getConfirmationCodeResponseForXs2a(ScaStatus scaStatus, ConsentStatus consentStatus) {
        SpiConsentConfirmationCodeValidationResponse response = new SpiConsentConfirmationCodeValidationResponse(scaStatus, consentStatus);
        return SpiResponse.builder().payload((Object)response).build();
    }
}

