/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthProfileServiceWrapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import feign.FeignException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;

public abstract class AuthConfirmationCodeServiceImpl<T> {
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final UserMgmtRestClient userMgmtRestClient;
    private final OauthProfileServiceWrapper oauthProfileServiceWrapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<T> checkConfirmationCode(@NotNull SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(spiAspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            String confirmationCodeToCheck = this.isOAuthRedirectFlow() ? sca.getAuthConfirmationCode() : spiCheckConfirmationCodeRequest.getConfirmationCode();
            ResponseEntity authConfirmationTOResponse = this.userMgmtRestClient.verifyAuthConfirmationCode(spiCheckConfirmationCodeRequest.getAuthorisationId(), confirmationCodeToCheck);
            SpiResponse<T> spiResponse = this.handleAuthConfirmationResponse((ResponseEntity<AuthConfirmationTO>)authConfirmationTOResponse);
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<T> completeAuthConfirmation(boolean authCodeConfirmed, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        try {
            ResponseEntity authConfirmationTOResponse = this.userMgmtRestClient.completeAuthConfirmation(sca.getAuthorisationId(), authCodeConfirmed);
            SpiResponse<T> spiResponse = this.handleAuthConfirmationResponse((ResponseEntity<AuthConfirmationTO>)authConfirmationTOResponse);
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public boolean checkConfirmationCodeInternally(String authorisationId, String confirmationCode, String scaAuthenticationData, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
        sca.setAuthorisationId(authorisationId);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(sca));
        String codeToCheck = confirmationCode;
        if (this.oauthProfileServiceWrapper.getScaRedirectFlow() == ScaRedirectFlow.OAUTH) {
            codeToCheck = sca.getAuthConfirmationCode();
        }
        return StringUtils.equals((CharSequence)codeToCheck, (CharSequence)scaAuthenticationData);
    }

    protected boolean isOAuthRedirectFlow() {
        return this.oauthProfileServiceWrapper.getScaRedirectFlow() == ScaRedirectFlow.OAUTH;
    }

    protected abstract SpiResponse<T> handleAuthConfirmationResponse(ResponseEntity<AuthConfirmationTO> var1);

    public AuthConfirmationCodeServiceImpl(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, UserMgmtRestClient userMgmtRestClient, OauthProfileServiceWrapper oauthProfileServiceWrapper) {
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.userMgmtRestClient = userMgmtRestClient;
        this.oauthProfileServiceWrapper = oauthProfileServiceWrapper;
    }
}

