/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.cms.CmsPsuPisClient;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiCommonPaymentTOMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.SpiScaStatusResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.AbstractAuthorisationSpi;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.GeneralPaymentService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentAuthorisationSpiImpl
extends AbstractAuthorisationSpi<SpiPayment>
implements PaymentAuthorisationSpi {
    private static final Logger log = LoggerFactory.getLogger(PaymentAuthorisationSpiImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(PaymentAuthorisationSpiImpl.class);
    private final GeneralPaymentService paymentService;
    private final LedgersSpiCommonPaymentTOMapper ledgersSpiCommonPaymentTOMapper;
    private final AspspConsentDataService aspspConsentDataService;
    private final ScaResponseMapper scaResponseMapper;
    private final PaymentRestClient paymentRestClient;
    private final CmsPsuPisClient cmsPsuPisClient;
    private final RequestProviderService requestProviderService;
    private final FeignExceptionReader feignExceptionReader;

    public PaymentAuthorisationSpiImpl(GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, RedirectScaRestClient redirectScaRestClient, KeycloakTokenService keycloakTokenService, GeneralPaymentService paymentService, LedgersSpiCommonPaymentTOMapper ledgersSpiCommonPaymentTOMapper, AspspConsentDataService aspspConsentDataService, ScaResponseMapper scaResponseMapper, PaymentRestClient paymentRestClient, CmsPsuPisClient cmsPsuPisClient, RequestProviderService requestProviderService, SpiScaStatusResponseMapper spiScaStatusResponseMapper) {
        super(authRequestInterceptor, consentDataService, authorisationService, scaMethodConverter, feignExceptionReader, keycloakTokenService, redirectScaRestClient, spiScaStatusResponseMapper);
        this.paymentService = paymentService;
        this.ledgersSpiCommonPaymentTOMapper = ledgersSpiCommonPaymentTOMapper;
        this.aspspConsentDataService = aspspConsentDataService;
        this.scaResponseMapper = scaResponseMapper;
        this.paymentRestClient = paymentRestClient;
        this.cmsPsuPisClient = cmsPsuPisClient;
        this.requestProviderService = requestProviderService;
        this.feignExceptionReader = feignExceptionReader;
    }

    @Override
    protected OpTypeTO getOpType() {
        return OpTypeTO.PAYMENT;
    }

    @Override
    protected TppMessage getAuthorisePsuFailureMessage(SpiPayment businessObject) {
        logger.error("Initiate payment failed: payment ID {}", (Object)businessObject.getPaymentId());
        return new TppMessage(MessageErrorCode.PAYMENT_FAILED, new Object[0]);
    }

    @Override
    protected String getBusinessObjectId(SpiPayment businessObject) {
        return businessObject.getPaymentId();
    }

    @Override
    protected GlobalScaResponseTO initiateBusinessObject(SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, String authorisationId) {
        if (businessObject.getPaymentStatus() == TransactionStatus.PATC) {
            return this.aspspConsentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
        }
        PaymentType paymentType = businessObject.getPaymentType();
        PaymentTO paymentTO = this.ledgersSpiCommonPaymentTOMapper.mapToPaymentTO(paymentType, (SpiPaymentInfo)businessObject);
        return this.paymentService.initiatePaymentInLedgers(businessObject, PaymentTypeTO.valueOf((String)paymentType.toString()), paymentTO);
    }

    @Override
    protected boolean isFirstInitiationOfMultilevelSca(SpiPayment businessObject, GlobalScaResponseTO scaPaymentResponseTO) {
        return !scaPaymentResponseTO.isMultilevelScaRequired() || businessObject.getPsuDataList().size() <= 1;
    }

    @Override
    protected GlobalScaResponseTO executeBusinessObject(SpiPayment businessObject) {
        try {
            ResponseEntity paymentExecutionResponse = this.paymentRestClient.executePayment(businessObject.getPaymentId());
            if (paymentExecutionResponse == null || paymentExecutionResponse.getBody() == null) {
                logger.error("Payment execution response is NULL");
                return null;
            }
            SCAPaymentResponseTO paymentResponseTO = (SCAPaymentResponseTO)paymentExecutionResponse.getBody();
            this.cmsPsuPisClient.updatePaymentStatus(businessObject.getPaymentId(), this.mapTransactionStatus(paymentResponseTO.getTransactionStatus()), this.requestProviderService.getInstanceId());
            return this.scaResponseMapper.toGlobalScaResponse(paymentResponseTO);
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Execute payment error: {}", (Object)devMessage);
            return null;
        }
    }

    @Override
    protected void updateStatusInCms(String paymentId, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO globalScaResponseTO = this.aspspConsentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
        TransactionStatus transactionStatus = this.getTransactionStatus(globalScaResponseTO.getScaStatus());
        this.cmsPsuPisClient.updatePaymentStatus(paymentId, transactionStatus, this.requestProviderService.getInstanceId());
    }

    @Override
    protected Optional<List<ScaUserDataTO>> getScaMethods(GlobalScaResponseTO sca) {
        if (sca.getScaMethods() == null) {
            return Optional.of(Collections.emptyList());
        }
        return super.getScaMethods(sca);
    }

    @Override
    protected SpiResponse<SpiPsuAuthorisationResponse> resolveErrorResponse(SpiPayment businessObject, FeignException feignException) {
        String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
        LedgersErrorCode errorCode = this.feignExceptionReader.getLedgersErrorCode(feignException);
        if (LedgersErrorCode.INSUFFICIENT_FUNDS.equals((Object)errorCode)) {
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_EXECUTED, devMessage)).build();
        }
        if (LedgersErrorCode.REQUEST_VALIDATION_FAILURE.equals((Object)errorCode)) {
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PRODUCT_UNKNOWN, devMessage)).build();
        }
        log.info("Initiate business object error: business object ID: {}, devMessage: {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
        return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.FAILURE)).build();
    }

    private TransactionStatus mapTransactionStatus(TransactionStatusTO transactionStatusTO) {
        return Optional.ofNullable(transactionStatusTO).map(ts -> TransactionStatus.valueOf((String)ts.name())).orElse(null);
    }

    private TransactionStatus getTransactionStatus(ScaStatusTO scaStatus) {
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.EXEMPTED).contains(scaStatus)) {
            return TransactionStatus.ACCP;
        }
        if (scaStatus == ScaStatusTO.PSUAUTHENTICATED) {
            return TransactionStatus.ACTC;
        }
        return TransactionStatus.RCVD;
    }
}

