/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AisConsentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.converter.SpiScaStatusResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import de.adorsys.aspsp.xs2a.connector.spi.impl.MultilevelScaService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.SpiMockData;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.AbstractAuthorisationSpi;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.ConsentAuthConfirmationCodeService;
import de.adorsys.aspsp.xs2a.connector.spi.util.AspspConsentDataExtractor;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.OperationInitiationRestClient;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiateAisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import feign.FeignException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AisConsentSpiImpl
extends AbstractAuthorisationSpi<SpiAccountConsent>
implements AisConsentSpi {
    private static final Logger logger = LoggerFactory.getLogger(AisConsentSpiImpl.class);
    private static final String USER_LOGIN = "{userLogin}";
    private static final String CONSENT_ID = "{consentId}";
    private static final String AUTH_ID = "{authorizationId}";
    private static final String TAN = "{tan}";
    private static final String DECOUPLED_USR_MSG = "Please check your app to continue... %s";
    private static final String SCA_STATUS_LOG = "SCA status is {}";
    private final AccountRestClient accountRestClient;
    private final LedgersSpiAccountMapper accountMapper;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final MultilevelScaService multilevelScaService;
    private final RedirectScaRestClient redirectScaRestClient;
    private final AisConsentMapper aisConsentMapper;
    private final ConsentAuthConfirmationCodeService authConfirmationCodeService;
    private final OperationInitiationRestClient operationInitiationRestClient;
    @Value(value="${xs2asandbox.tppui.online-banking.url}")
    private String onlineBankingUrl;

    @Autowired
    public AisConsentSpiImpl(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, FeignExceptionReader feignExceptionReader, AccountRestClient accountRestClient, LedgersSpiAccountMapper accountMapper, MultilevelScaService multilevelScaService, RedirectScaRestClient redirectScaRestClient, KeycloakTokenService keycloakTokenService, AisConsentMapper aisConsentMapper, ConsentAuthConfirmationCodeService authConfirmationCodeService, SpiScaStatusResponseMapper spiScaStatusResponseMapper, OperationInitiationRestClient operationInitiationRestClient) {
        super(authRequestInterceptor, consentDataService, authorisationService, scaMethodConverter, feignExceptionReader, keycloakTokenService, redirectScaRestClient, spiScaStatusResponseMapper);
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.accountRestClient = accountRestClient;
        this.accountMapper = accountMapper;
        this.multilevelScaService = multilevelScaService;
        this.redirectScaRestClient = redirectScaRestClient;
        this.aisConsentMapper = aisConsentMapper;
        this.authConfirmationCodeService = authConfirmationCodeService;
        this.operationInitiationRestClient = operationInitiationRestClient;
    }

    public SpiResponse<SpiInitiateAisConsentResponse> initiateAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO globalScaResponse;
        byte[] initialAspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        if (ArrayUtils.isEmpty((byte[])initialAspspConsentData)) {
            return this.firstCallInstantiatingConsent(accountConsent, aspspConsentDataProvider, new SpiInitiateAisConsentResponse(), contextData.getPsuData());
        }
        try {
            globalScaResponse = this.initiateConsentInternal(accountConsent, null);
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Initiate AIS consent failed: consent ID: {}, devMessage: {}", (Object)accountConsent.getId(), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT)).build();
        }
        if (globalScaResponse != null) {
            logger.info(SCA_STATUS_LOG, (Object)globalScaResponse.getScaStatus());
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(globalScaResponse));
        }
        SpiInitiateAisConsentResponse spiInitiateAisConsentResponse = new SpiInitiateAisConsentResponse(accountConsent.getAccess(), false, "mocked PSU message from the bank", SpiMockData.SCA_METHODS, SpiMockData.TPP_MESSAGES);
        return SpiResponse.builder().payload((Object)spiInitiateAisConsentResponse).build();
    }

    public SpiResponse<SpiConsentStatusResponse> getConsentStatus(@NotNull SpiContextData contextData, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return SpiResponse.builder().payload((Object)new SpiConsentStatusResponse(accountConsent.getConsentStatus(), "Mocked PSU message from SPI for this consent")).build();
    }

    public SpiResponse<SpiResponse.VoidResponse> revokeAisConsent(@NotNull SpiContextData contextData, SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData(), false);
            sca.setScaStatus(ScaStatusTO.FINALISED);
            sca.setStatusDate(LocalDateTime.now());
            sca.setBearerToken(new BearerTokenTO());
            String scaStatusName = sca.getScaStatus().name();
            logger.info(SCA_STATUS_LOG, (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(sca));
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Revoke AIS consent failed: consent ID: {}, devMessage: {}", (Object)accountConsent.getId(), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, feignException.getMessage())).build();
        }
        return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizeConsentResponse = this.redirectScaRestClient.validateScaCode(sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            if (authorizeConsentResponse == null || authorizeConsentResponse.getBody() == null) {
                logger.error("Validate SCA code response is NULL");
                SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, new Object[0])).build();
                return spiResponse;
            }
            GlobalScaResponseTO authorizeConsentResponseBody = (GlobalScaResponseTO)authorizeConsentResponse.getBody();
            String scaStatusName = sca.getScaStatus().name();
            logger.info(SCA_STATUS_LOG, (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(authorizeConsentResponseBody, !authorizeConsentResponseBody.isPartiallyAuthorised()));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(this.getConsentStatus(authorizeConsentResponseBody))).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Verify sca authorisation failed: consent ID {}, devMessage {}", (Object)accountConsent.getId(), (Object)devMessage);
            LedgersErrorCode errorCode = this.feignExceptionReader.getLedgersErrorCode(feignException);
            if (LedgersErrorCode.SCA_VALIDATION_ATTEMPT_FAILED.equals((Object)errorCode)) {
                SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(accountConsent.getConsentStatus(), SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
                return spiResponse;
            }
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    @Override
    protected String generatePsuMessage(@NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiAuthorizationCodeResult> response) {
        List<String> challengeDataParts = Arrays.asList(((SpiAuthorizationCodeResult)response.getPayload()).getChallengeData().getAdditionalInformation().split(" "));
        int indexOfTan = challengeDataParts.indexOf("is") + 1;
        String encryptedConsentId = AspspConsentDataExtractor.extractEncryptedConsentId(aspspConsentDataProvider);
        String url = this.onlineBankingUrl.replace(USER_LOGIN, contextData.getPsuData().getPsuId()).replace(CONSENT_ID, encryptedConsentId).replace(AUTH_ID, authorisationId).replace(TAN, challengeDataParts.get(indexOfTan));
        return String.format(DECOUPLED_USR_MSG, url);
    }

    @Override
    protected boolean isFirstInitiationOfMultilevelSca(SpiAccountConsent businessObject, GlobalScaResponseTO scaConsentResponseTO) {
        return !scaConsentResponseTO.isMultilevelScaRequired() || businessObject.getPsuData().size() <= 1;
    }

    @Override
    protected GlobalScaResponseTO executeBusinessObject(SpiAccountConsent businessObject) {
        return null;
    }

    @Override
    protected void updateStatusInCms(String businessObjectId, SpiAspspConsentDataProvider aspspConsentDataProvider) {
    }

    @Override
    protected OpTypeTO getOpType() {
        return OpTypeTO.CONSENT;
    }

    @Override
    protected TppMessage getAuthorisePsuFailureMessage(SpiAccountConsent businessObject) {
        logger.error("Initiate consent failed: consent ID: {}", (Object)businessObject.getId());
        return new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0]);
    }

    @Override
    protected String getBusinessObjectId(SpiAccountConsent businessObject) {
        return businessObject.getId();
    }

    @Override
    protected GlobalScaResponseTO initiateBusinessObject(SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, String authorisationId) {
        return this.initiateConsentInternal(businessObject, authorisationId);
    }

    @Override
    public SpiResponse<SpiAvailableScaMethodsResponse> requestAvailableScaMethods(@NotNull SpiContextData contextData, SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO sca = this.getScaObjectResponse(aspspConsentDataProvider, true);
        if (this.validateStatuses(businessObject, sca)) {
            return SpiResponse.builder().payload((Object)new SpiAvailableScaMethodsResponse(Collections.emptyList())).build();
        }
        return super.requestAvailableScaMethods(contextData, businessObject, aspspConsentDataProvider);
    }

    @NotNull
    public SpiResponse<SpiConsentConfirmationCodeValidationResponse> checkConfirmationCode(@NotNull SpiContextData spiContextData, @NotNull SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        return this.authConfirmationCodeService.checkConfirmationCode(spiCheckConfirmationCodeRequest, spiAspspConsentDataProvider);
    }

    @NotNull
    public SpiResponse<SpiConsentConfirmationCodeValidationResponse> notifyConfirmationCodeValidation(@NotNull SpiContextData spiContextData, boolean confirmationCodeValidationResult, @NotNull SpiAccountConsent businessObject, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        return this.authConfirmationCodeService.completeAuthConfirmation(confirmationCodeValidationResult, spiAspspConsentDataProvider);
    }

    public boolean checkConfirmationCodeInternally(String authorisationId, String confirmationCode, String scaAuthenticationData, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.authConfirmationCodeService.checkConfirmationCodeInternally(authorisationId, confirmationCode, scaAuthenticationData, aspspConsentDataProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalScaResponseTO initiateConsentInternal(SpiAccountConsent accountConsent, String authorisationId) {
        try {
            AisConsentTO aisConsentTO;
            ResponseEntity initiateAisConsentResponse;
            boolean isAllPsd2;
            SpiAccountAccess spiAccountAccess = accountConsent.getAccess();
            boolean isAllAvailableAccounts = spiAccountAccess.getAvailableAccounts() != null;
            boolean isAllAvailableAccountsWithBalance = spiAccountAccess.getAvailableAccountsWithBalance() != null;
            boolean bl = isAllPsd2 = spiAccountAccess.getAllPsd2() != null;
            if (isAllAvailableAccounts || isAllAvailableAccountsWithBalance || isAllPsd2) {
                List<SpiAccountReference> references = this.getReferences();
                spiAccountAccess.setAccounts(references);
                if (isAllAvailableAccountsWithBalance || isAllPsd2) {
                    spiAccountAccess.setBalances(references);
                }
                if (isAllPsd2) {
                    spiAccountAccess.setTransactions(references);
                }
            }
            if ((initiateAisConsentResponse = this.operationInitiationRestClient.initiateAisConsent(aisConsentTO = this.aisConsentMapper.mapToAisConsent(accountConsent))) != null && initiateAisConsentResponse.getBody() != null) {
                GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)initiateAisConsentResponse.getBody();
                this.authRequestInterceptor.setAccessToken(globalScaResponseTO.getBearerToken().getAccess_token());
                globalScaResponseTO.setAuthorisationId(authorisationId);
                if (globalScaResponseTO.getScaStatus() == ScaStatusTO.EXEMPTED) {
                    GlobalScaResponseTO globalScaResponseTO2 = globalScaResponseTO;
                    return globalScaResponseTO2;
                }
                StartScaOprTO startScaOprTO = new StartScaOprTO(accountConsent.getId(), OpTypeTO.CONSENT);
                startScaOprTO.setAuthorisationId(authorisationId);
                ResponseEntity consentScaResponse = this.redirectScaRestClient.startSca(startScaOprTO);
                GlobalScaResponseTO globalScaResponseTO3 = (GlobalScaResponseTO)consentScaResponse.getBody();
                return globalScaResponseTO3;
            }
            logger.error("Initiate AIS consent response or bearer token is NULL");
            GlobalScaResponseTO globalScaResponseTO = null;
            return globalScaResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private List<SpiAccountReference> getReferences() {
        return Optional.ofNullable((List)this.accountRestClient.getListOfAccounts().getBody()).map(l -> l.stream().map(this.accountMapper::toSpiAccountDetails).map(SpiAccountReference::new).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private boolean isCardAccountConsent(Set<SpiAccountReference> spiAccountReferences) {
        return spiAccountReferences.stream().anyMatch(ref -> StringUtils.isNotBlank((CharSequence)ref.getMaskedPan()) || StringUtils.isNotBlank((CharSequence)ref.getPan()));
    }

    private ConsentStatus getConsentStatus(GlobalScaResponseTO globalScaResponse) {
        if (globalScaResponse != null && globalScaResponse.isPartiallyAuthorised() && ScaStatusTO.FINALISED.equals((Object)globalScaResponse.getScaStatus())) {
            return ConsentStatus.PARTIALLY_AUTHORISED;
        }
        return ConsentStatus.VALID;
    }

    private boolean isMultilevelScaRequired(@NotNull SpiAccountConsent accountConsent, @NotNull SpiPsuData spiPsuData) {
        SpiAccountAccess access = accountConsent.getAccess();
        Set<SpiAccountReference> spiAccountReferences = Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).flatMap(Collection::stream).collect(Collectors.toSet());
        if (this.isCardAccountConsent(spiAccountReferences)) {
            return false;
        }
        return this.multilevelScaService.isMultilevelScaRequired(spiPsuData, spiAccountReferences);
    }

    private <T extends SpiInitiateAisConsentResponse> SpiResponse<T> firstCallInstantiatingConsent(@NotNull SpiAccountConsent accountConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload, @NotNull SpiPsuData spiPsuData) {
        boolean isMultilevelScaRequired;
        try {
            isMultilevelScaRequired = this.isMultilevelScaRequired(accountConsent, spiPsuData);
        }
        catch (FeignException e) {
            logger.error("Error during REST call for consent initiation to ledgers for account multilevel checking, PSU ID: {}", (Object)spiPsuData.getPsuId());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0])).build();
        }
        GlobalScaResponseTO response = new GlobalScaResponseTO();
        response.setOpType(OpTypeTO.CONSENT);
        response.setScaStatus(ScaStatusTO.STARTED);
        response.setMultilevelScaRequired(isMultilevelScaRequired);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response, false));
        responsePayload.setAccountAccess(accountConsent.getAccess());
        responsePayload.setMultilevelScaRequired(isMultilevelScaRequired);
        responsePayload.setScaMethods(SpiMockData.SCA_METHODS);
        responsePayload.setPsuMessage("mocked PSU message from the bank");
        responsePayload.setTppMessages(SpiMockData.TPP_MESSAGES);
        return SpiResponse.builder().payload(responsePayload).build();
    }
}

