/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiHrefType;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiLinks;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SpiMockData {
    public static final SpiLinks SPI_LINKS = SpiMockData.buildSpiLinks();
    public static final Set<TppMessageInformation> TPP_MESSAGES = SpiMockData.buildTppMessages();
    public static final Set<TppMessageInformation> TPP_MESSAGES_START_AUTHORISATION = SpiMockData.buildTppMessagesStartAuthorisation();
    public static final List<SpiAuthenticationObject> SCA_METHODS = SpiMockData.buildScaMethods();
    public static final String PSU_MESSAGE = "mocked PSU message from the bank";
    public static final String PSU_MESSAGE_START_AUTHORISATION = "Start authorisation mocked PSU message from the bank";
    public static final String DECOUPLED_PSU_MESSAGE = "Please check your app to continue...";
    public static final boolean FUNDS_AVAILABLE = true;

    private static SpiLinks buildSpiLinks() {
        SpiLinks spiLinks = new SpiLinks();
        spiLinks.setAccount(new SpiHrefType("Mock spi account link from the bank"));
        return spiLinks;
    }

    private static Set<TppMessageInformation> buildTppMessages() {
        HashSet<TppMessageInformation> tppInformationSet = new HashSet<TppMessageInformation>();
        tppInformationSet.add(TppMessageInformation.buildWithCustomWarning((MessageErrorCode)MessageErrorCode.FORMAT_ERROR, (String)"Mocked tpp message from the bank"));
        return tppInformationSet;
    }

    private static Set<TppMessageInformation> buildTppMessagesStartAuthorisation() {
        HashSet<TppMessageInformation> tppInformationSet = new HashSet<TppMessageInformation>();
        tppInformationSet.add(TppMessageInformation.buildWithCustomWarning((MessageErrorCode)MessageErrorCode.FORMAT_ERROR, (String)"Start authorisation Mocked tpp message from the bank"));
        return tppInformationSet;
    }

    private static List<SpiAuthenticationObject> buildScaMethods() {
        SpiAuthenticationObject psi = new SpiAuthenticationObject();
        psi.setAuthenticationType("Mocked Authentication type from the bank");
        psi.setAuthenticationMethodId("Mocked Authentication id from the bank");
        psi.setDecoupled(false);
        psi.setName("Mocked name from the bank");
        psi.setAuthenticationVersion("Mocked Authentication version from the bank");
        return Collections.singletonList(psi);
    }

    private SpiMockData() {
    }
}

