/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LoginAttemptResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class LoginAttemptAspspConsentDataService {
    @Value(value="${xs2a.sca.login.failed.max:3}")
    private int loginFailedMax;
    private final ObjectMapper objectMapper;

    public byte[] store(LoginAttemptResponse response) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)response);
        }
        catch (IOException e) {
            throw FeignExceptionHandler.getException(HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    public LoginAttemptResponse response(byte[] aspspConsentData) {
        try {
            return this.fromBytes(aspspConsentData);
        }
        catch (IOException e) {
            throw FeignExceptionHandler.getException(HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    private LoginAttemptResponse fromBytes(byte[] bytes) throws IOException {
        String type = this.readType(bytes);
        if (LoginAttemptResponse.class.getSimpleName().equals(type)) {
            return (LoginAttemptResponse)this.objectMapper.readValue(bytes, LoginAttemptResponse.class);
        }
        return null;
    }

    private String readType(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.objectMapper.readTree(tokenBytes);
        JsonNode objectType = jsonNode.get("objectType");
        if (objectType == null) {
            return null;
        }
        return objectType.textValue();
    }

    public int getRemainingLoginAttempts(int loginFailedCount) {
        return Math.max(this.loginFailedMax - loginFailedCount, 0);
    }

    public LoginAttemptAspspConsentDataService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

