/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import feign.FeignException;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FeignExceptionReader {
    private static final Logger log = LoggerFactory.getLogger(FeignExceptionReader.class);
    private final ObjectMapper objectMapper;

    public String getErrorMessage(FeignException feignException) {
        return Optional.ofNullable(feignException.content()).map(this::readTree).map(this::getMessage).map(JsonNode::asText).orElse(null);
    }

    public LedgersErrorCode getLedgersErrorCode(FeignException feignException) {
        return LedgersErrorCode.getFromString(this.getErrorCode(feignException)).orElse(null);
    }

    private String getErrorCode(FeignException feignException) {
        return Optional.ofNullable(feignException.content()).map(this::readTree).map(this::getCode).map(JsonNode::asText).orElse(null);
    }

    private JsonNode getCode(JsonNode jsonNode) {
        return jsonNode.get("errorCode");
    }

    private JsonNode getMessage(JsonNode jsonNode) {
        JsonNode devMessage = jsonNode.get("devMessage");
        if (devMessage == null) {
            return jsonNode.get("message");
        }
        return devMessage;
    }

    private JsonNode readTree(byte[] content) {
        try {
            return this.objectMapper.readTree(content);
        }
        catch (IOException ex) {
            log.error("Could not parse Error Message from Bank!");
            return null;
        }
    }

    public FeignExceptionReader(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

