/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.xs2a.core.pis.FrequencyCode;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiAddress;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class LedgersSpiPaymentMapper {
    private final LedgersSpiAccountMapper accountMapper;

    public SpiSinglePayment toSpiSinglePayment(PaymentTO paymentTO) {
        if (paymentTO == null) {
            return null;
        }
        SpiSinglePayment spiSinglePayment = new SpiSinglePayment(paymentTO.getPaymentProduct());
        this.fillCommonPart(paymentTO, spiSinglePayment);
        return spiSinglePayment;
    }

    public SpiPeriodicPayment mapToSpiPeriodicPayment(PaymentTO paymentTO) {
        if (paymentTO == null) {
            return null;
        }
        SpiPeriodicPayment spiPeriodicPayment = new SpiPeriodicPayment(paymentTO.getPaymentProduct());
        this.fillCommonPart(paymentTO, (SpiSinglePayment)spiPeriodicPayment);
        spiPeriodicPayment.setStartDate(paymentTO.getStartDate());
        spiPeriodicPayment.setEndDate(paymentTO.getEndDate());
        spiPeriodicPayment.setFrequency(FrequencyCode.valueOf((String)paymentTO.getFrequency().name()));
        spiPeriodicPayment.setDayOfExecution(PisDayOfExecution.fromValue((Object)String.valueOf(paymentTO.getDayOfExecution())));
        spiPeriodicPayment.setExecutionRule((PisExecutionRule)PisExecutionRule.getByValue((String)paymentTO.getExecutionRule()).orElse(null));
        return spiPeriodicPayment;
    }

    public SpiBulkPayment mapToSpiBulkPayment(PaymentTO paymentTO) {
        if (paymentTO == null) {
            return null;
        }
        SpiBulkPayment spiBulkPayment = new SpiBulkPayment();
        spiBulkPayment.setPaymentId(paymentTO.getPaymentId());
        spiBulkPayment.setBatchBookingPreferred(paymentTO.getBatchBookingPreferred());
        spiBulkPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(paymentTO.getDebtorAccount()));
        spiBulkPayment.setDebtorName(paymentTO.getDebtorName());
        spiBulkPayment.setRequestedExecutionDate(paymentTO.getRequestedExecutionDate());
        spiBulkPayment.setRequestedExecutionTime(this.toDateTime(paymentTO.getRequestedExecutionDate(), paymentTO.getRequestedExecutionTime()));
        spiBulkPayment.setPaymentStatus(TransactionStatus.valueOf((String)paymentTO.getTransactionStatus().name()));
        spiBulkPayment.setPayments(this.toSpiSinglePaymentsList(paymentTO));
        spiBulkPayment.setPaymentProduct(paymentTO.getPaymentProduct());
        return spiBulkPayment;
    }

    private List<SpiSinglePayment> toSpiSinglePaymentsList(PaymentTO paymentTO) {
        ArrayList<SpiSinglePayment> spiSinglePaymentList = new ArrayList<SpiSinglePayment>();
        paymentTO.getTargets().forEach(paymentTargetTO -> {
            SpiSinglePayment spiSinglePayment = new SpiSinglePayment(paymentTO.getPaymentProduct());
            this.fillCommonPartFromPaymentTargetTO((PaymentTargetTO)paymentTargetTO, spiSinglePayment);
            this.fillCommonPartFromPaymentTO(paymentTO, spiSinglePayment);
            spiSinglePaymentList.add(spiSinglePayment);
        });
        return spiSinglePaymentList;
    }

    private void fillCommonPart(PaymentTO paymentTO, SpiSinglePayment spiPayment) {
        this.fillCommonPartFromPaymentTargetTO((PaymentTargetTO)paymentTO.getTargets().get(0), spiPayment);
        this.fillCommonPartFromPaymentTO(paymentTO, spiPayment);
    }

    private void fillCommonPartFromPaymentTO(PaymentTO paymentTO, SpiSinglePayment spiPayment) {
        spiPayment.setDebtorAccount(this.accountMapper.toSpiAccountReference(paymentTO.getDebtorAccount()));
        spiPayment.setPaymentStatus((TransactionStatus)Optional.ofNullable(paymentTO.getTransactionStatus()).map(Enum::name).map(TransactionStatus::valueOf).orElse(null));
        spiPayment.setRequestedExecutionDate(paymentTO.getRequestedExecutionDate());
        spiPayment.setRequestedExecutionTime(this.toDateTime(paymentTO.getRequestedExecutionDate(), paymentTO.getRequestedExecutionTime()));
        spiPayment.setDebtorName(paymentTO.getDebtorName());
    }

    private void fillCommonPartFromPaymentTargetTO(PaymentTargetTO paymentTargetTO, SpiSinglePayment spiPayment) {
        spiPayment.setPaymentId(paymentTargetTO.getPaymentId());
        spiPayment.setEndToEndIdentification(paymentTargetTO.getEndToEndIdentification());
        spiPayment.setCreditorAgent(paymentTargetTO.getCreditorAgent());
        spiPayment.setCreditorName(paymentTargetTO.getCreditorName());
        spiPayment.setCreditorAddress(this.toSpiAddress(paymentTargetTO.getCreditorAddress()));
        spiPayment.setRemittanceInformationUnstructured(paymentTargetTO.getRemittanceInformationUnstructured());
        spiPayment.setInstructedAmount(this.accountMapper.toSpiAmount(paymentTargetTO.getInstructedAmount()));
        spiPayment.setCreditorAccount(this.accountMapper.toSpiAccountReference(paymentTargetTO.getCreditorAccount()));
        spiPayment.setRemittanceInformationStructured(this.mapToRemittanceString(paymentTargetTO.getRemittanceInformationStructured()));
        spiPayment.setPurposeCode((PurposeCode)Optional.ofNullable(paymentTargetTO.getPurposeCode()).map(Enum::name).map(PurposeCode::fromValue).orElse(null));
    }

    public String mapToRemittanceString(RemittanceInformationStructuredTO remittanceInformationStructuredTO) {
        return Optional.ofNullable(remittanceInformationStructuredTO).map(RemittanceInformationStructuredTO::getReference).orElse(null);
    }

    private OffsetDateTime toDateTime(LocalDate date, LocalTime time) {
        return Optional.ofNullable(date).map(d -> LocalDateTime.of(d, Optional.ofNullable(time).orElse(LocalTime.ofSecondOfDay(0L))).atOffset(ZoneOffset.UTC)).orElse(null);
    }

    private SpiAddress toSpiAddress(AddressTO address) {
        return Optional.ofNullable(address).map(a -> new SpiAddress(a.getStreet(), a.getBuildingNumber(), a.getCity(), a.getPostalCode(), a.getCountry())).orElse(null);
    }

    public LedgersSpiPaymentMapper(LedgersSpiAccountMapper accountMapper) {
        this.accountMapper = accountMapper;
    }
}

