/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.mock;

import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class IbanResolverMockService {
    private Map<String, String> ibanMap = new HashMap<String, String>();

    @PostConstruct
    public void setup() {
        this.ibanMap.put("493702******0836", "DE69760700240340283600");
        this.ibanMap.put("4937023494670836", "DE69760700240340283600");
        this.ibanMap.put("525412******3241", "DE80760700240271232400");
        this.ibanMap.put("5254127692833241", "DE80760700240271232400");
        this.ibanMap.put("037504******4669", "DE38760700240320465700");
        this.ibanMap.put("0375049529584669", "DE38760700240320465700");
        this.ibanMap.put("111122******4444", "DE17123456780000000001");
        this.ibanMap.put("1111222233334444", "DE17123456780000000001");
        this.ibanMap.put("222233******5555", "DE87123456780000000002");
        this.ibanMap.put("2222333344445555", "DE87123456780000000002");
        this.ibanMap.put("333344******6666", "DE60123456780000000003");
        this.ibanMap.put("3333444455556666", "DE60123456780000000003");
        this.ibanMap.put("444455******7777", "DE33123456780000000004");
        this.ibanMap.put("4444555566667777", "DE33123456780000000004");
    }

    public String handleIbanByAccountReference(SpiAccountReference accountReference) {
        return Optional.ofNullable(this.ibanMap.get(accountReference.getMaskedPan())).orElse(this.ibanMap.get(accountReference.getPan()));
    }

    public Optional<String> getIbanByMaskedPan(String maskedPan) {
        return Optional.ofNullable(this.ibanMap.get(maskedPan));
    }

    public String getMaskedPanByIban(String iban) {
        Set keys = this.ibanMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(iban)).map(Map.Entry::getKey).collect(Collectors.toSet());
        return keys.stream().filter(key -> key.contains("******")).findFirst().orElse("No value of masked PAN for this IBAN");
    }
}

