/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment;

import de.adorsys.aspsp.xs2a.connector.cms.CmsPsuPisClient;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import de.adorsys.aspsp.xs2a.connector.spi.impl.MultilevelScaService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.SpiMockData;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.OperationInitiationRestClient;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiGetPaymentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentExecutionResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import feign.Response;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@PropertySource(value={"classpath:mock-data.properties"})
public class GeneralPaymentService {
    private static final Logger logger = LoggerFactory.getLogger(GeneralPaymentService.class);
    private static final String XML_MEDIA_TYPE = "application/xml";
    private static final String PSU_MESSAGE = "Mocked PSU message from SPI for this payment";
    private static final String DEBTOR_NAME = "Mocked debtor name";
    private final PaymentRestClient paymentRestClient;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final String transactionStatusXmlBody;
    private final MultilevelScaService multilevelScaService;
    private final RedirectScaRestClient redirectScaRestClient;
    private final CmsPsuPisClient cmsPsuPisClient;
    private final RequestProviderService requestProviderService;
    private final OperationInitiationRestClient operationInitiationRestClient;

    public GeneralPaymentService(PaymentRestClient ledgersRestClient, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, FeignExceptionReader feignExceptionReader, @Value(value="${test-transaction-status-xml-body}") String transactionStatusXmlBody, MultilevelScaService multilevelScaService, RedirectScaRestClient redirectScaRestClient, CmsPsuPisClient cmsPsuPisClient, RequestProviderService requestProviderService, OperationInitiationRestClient operationInitiationRestClient) {
        this.paymentRestClient = ledgersRestClient;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.transactionStatusXmlBody = transactionStatusXmlBody;
        this.multilevelScaService = multilevelScaService;
        this.redirectScaRestClient = redirectScaRestClient;
        this.cmsPsuPisClient = cmsPsuPisClient;
        this.requestProviderService = requestProviderService;
        this.operationInitiationRestClient = operationInitiationRestClient;
    }

    public <T extends SpiPaymentInitiationResponse> SpiResponse<T> firstCallInstantiatingPayment(@NotNull PaymentTypeTO paymentType, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, T responsePayload, @NotNull SpiPsuData spiPsuData, Set<SpiAccountReference> spiAccountReferences) {
        boolean isMultilevelScaRequired;
        String paymentId = StringUtils.isNotBlank((CharSequence)payment.getPaymentId()) ? payment.getPaymentId() : Ids.id();
        GlobalScaResponseTO response = new GlobalScaResponseTO();
        response.setOperationObjectId(paymentId);
        response.setOpType(OpTypeTO.PAYMENT);
        responsePayload.setPaymentId(paymentId);
        responsePayload.setTransactionStatus(TransactionStatus.RCVD);
        try {
            isMultilevelScaRequired = this.multilevelScaService.isMultilevelScaRequired(spiPsuData, spiAccountReferences);
        }
        catch (FeignException e) {
            logger.error("Error during REST call for payment initiation to ledgers for account multilevel checking, PSU ID: {}", (Object)spiPsuData.getPsuId());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0])).build();
        }
        response.setMultilevelScaRequired(isMultilevelScaRequired);
        responsePayload.setMultilevelScaRequired(isMultilevelScaRequired);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response, false));
        responsePayload.setPsuMessage("mocked PSU message from the bank");
        responsePayload.setScaMethods(SpiMockData.SCA_METHODS);
        responsePayload.setTppMessages(SpiMockData.TPP_MESSAGES);
        return SpiResponse.builder().payload(responsePayload).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiGetPaymentStatusResponse> getPaymentStatusById(@NotNull PaymentTypeTO paymentType, @NotNull String acceptMediaType, @NotNull String paymentId, @NotNull TransactionStatus spiTransactionStatus, @NotNull byte[] aspspConsentData) {
        if (acceptMediaType.equals(XML_MEDIA_TYPE)) {
            return SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(spiTransactionStatus, null, XML_MEDIA_TYPE, this.transactionStatusXmlBody.getBytes(), PSU_MESSAGE, SpiMockData.SPI_LINKS, SpiMockData.TPP_MESSAGES)).build();
        }
        if (!TransactionStatus.ACSP.equals((Object)spiTransactionStatus)) {
            return SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(spiTransactionStatus, null, "application/json", null, PSU_MESSAGE, SpiMockData.SPI_LINKS, SpiMockData.TPP_MESSAGES)).build();
        }
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentData);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment status by ID with type: {} and ID: {}", (Object)paymentType, (Object)paymentId);
            TransactionStatusTO response = (TransactionStatusTO)this.paymentRestClient.getPaymentStatusById(sca.getOperationObjectId()).getBody();
            TransactionStatus status = Optional.ofNullable(response).map(r -> TransactionStatus.valueOf((String)r.name())).orElseThrow(() -> FeignException.errorStatus((String)"Request failed, response was 200, but body was empty!", (Response)Response.builder().status(HttpStatus.BAD_REQUEST.value()).build()));
            logger.info("Transaction status: {}", (Object)status);
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiGetPaymentStatusResponse(status, null, "application/json", null, PSU_MESSAGE, SpiMockData.SPI_LINKS, SpiMockData.TPP_MESSAGES)).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Get payment status by ID failed: payment ID: {}, devMessage: {}", (Object)paymentId, (Object)devMessage);
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, devMessage, new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpiResponse<SpiPaymentExecutionResponse> verifyScaAuthorisationAndExecutePaymentWithPaymentResponse(@NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity paymentAuthorisationValidationResponse = this.redirectScaRestClient.validateScaCode(sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            if (paymentAuthorisationValidationResponse != null && paymentAuthorisationValidationResponse.getBody() != null && paymentAuthorisationValidationResponse.getStatusCode() == HttpStatus.OK) {
                ResponseEntity globalScaResponseTOResponse;
                GlobalScaResponseTO paymentAuthorisationValidationResponseBody = (GlobalScaResponseTO)paymentAuthorisationValidationResponse.getBody();
                if (paymentAuthorisationValidationResponseBody.getBearerToken() != null) {
                    String authorisationBearerToken = paymentAuthorisationValidationResponseBody.getBearerToken().getAccess_token();
                    this.authRequestInterceptor.setAccessToken(authorisationBearerToken);
                }
                if ((globalScaResponseTOResponse = this.operationInitiationRestClient.execution(OpTypeTO.PAYMENT, sca.getOperationObjectId())) != null && globalScaResponseTOResponse.getBody() != null && globalScaResponseTOResponse.getStatusCode() == HttpStatus.ACCEPTED) {
                    GlobalScaResponseTO paymentExecutionResponse = (GlobalScaResponseTO)globalScaResponseTOResponse.getBody();
                    this.cmsPsuPisClient.updatePaymentStatus(paymentExecutionResponse.getOperationObjectId(), this.getTransactionStatus(paymentExecutionResponse.getTransactionStatus()), this.requestProviderService.getInstanceId());
                }
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(paymentAuthorisationValidationResponseBody));
                String scaStatus = Optional.ofNullable(paymentAuthorisationValidationResponseBody).map(GlobalScaResponseTO::getScaStatus).map(Enum::name).orElse(null);
                logger.info("SCA status is: {}", (Object)scaStatus);
                ResponseEntity paymentStatusResponse = this.paymentRestClient.getPaymentStatusById(sca.getOperationObjectId());
                SpiResponse spiResponse = SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse((TransactionStatusTO)paymentStatusResponse.getBody())).build();
                return spiResponse;
            }
            SpiResponse paymentAuthorisationValidationResponseBody = SpiResponse.builder().payload((Object)new SpiPaymentExecutionResponse(SpiAuthorisationStatus.FAILURE)).build();
            return paymentAuthorisationValidationResponseBody;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.info("Verify SCA authorisation and execute payment failed: payment ID: {}, devMessage: {}", (Object)spiScaConfirmation.getPaymentId(), (Object)devMessage);
            LedgersErrorCode errorCode = this.feignExceptionReader.getLedgersErrorCode(feignException);
            if (LedgersErrorCode.SCA_VALIDATION_ATTEMPT_FAILED.equals((Object)errorCode)) {
                SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiPaymentExecutionResponse(SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
                return spiResponse;
            }
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        catch (Exception exception) {
            SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_EXECUTED, new Object[0])).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    @NotNull
    public SpiResponse<SpiPaymentExecutionResponse> executePaymentWithoutSca(@NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO response = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(response.getBearerToken().getAccess_token());
            ScaStatusTO scaStatus = response.getScaStatus();
            String scaStatusName = scaStatus.name();
            logger.info("Getting payment transaction status by payment id {}", (Object)response.getOperationObjectId());
            TransactionStatusTO transactionStatusTO = (TransactionStatusTO)this.paymentRestClient.getPaymentStatusById(response.getOperationObjectId()).getBody();
            if (transactionStatusTO != null && (ScaStatusTO.EXEMPTED.equals((Object)scaStatus) || ScaStatusTO.FINALISED.equals((Object)scaStatus))) {
                logger.info("SCA status is: {}", (Object)scaStatusName);
                logger.info("Payment scheduled for execution. Transaction status is: {}. Also see SCA status", (Object)transactionStatusTO);
                return SpiResponse.builder().payload((Object)this.spiPaymentExecutionResponse(transactionStatusTO)).build();
            }
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_PAYMENT_NOT_EXECUTED, new Object[]{transactionStatusTO, scaStatusName})).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Execute payment without SCA failed: devMessage {}", (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR, devMessage)).build();
        }
    }

    public <P extends SpiPayment> SpiResponse<P> getPaymentById(P payment, SpiAspspConsentDataProvider aspspConsentDataProvider, Function<PaymentTO, P> mapperToSpiPayment) {
        Function<SpiPayment, SpiResponse> buildSuccessResponse = p -> SpiResponse.builder().payload(p).build();
        if (!TransactionStatus.ACSP.equals((Object)payment.getPaymentStatus())) {
            this.setDebtorNameIfNull(payment);
            return buildSuccessResponse.apply(payment);
        }
        Supplier<SpiResponse> buildFailedResponse = () -> SpiResponse.builder().error(new TppMessage(MessageErrorCode.PAYMENT_FAILED_INCORRECT_ID, new Object[0])).build();
        return this.getPaymentFromLedgers(payment, aspspConsentDataProvider.loadAspspConsentData()).map(this::setDebtorNameIfNull).map(mapperToSpiPayment).map(buildSuccessResponse).orElseGet(buildFailedResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> GlobalScaResponseTO initiatePaymentInLedgers(P payment, PaymentTypeTO paymentTypeTO, PaymentTO request) {
        try {
            GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)this.operationInitiationRestClient.initiatePayment(paymentTypeTO, request).getBody();
            logger.debug("{} payment body: {}", (Object)paymentTypeTO, payment);
            GlobalScaResponseTO globalScaResponseTO2 = globalScaResponseTO;
            return globalScaResponseTO2;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalScaResponseTO initiatePaymentCancellationInLedgers(String paymentId) {
        try {
            GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)this.operationInitiationRestClient.initiatePmtCancellation(paymentId).getBody();
            logger.debug("Payment cancellation, ID: {}", (Object)paymentId);
            GlobalScaResponseTO globalScaResponseTO2 = globalScaResponseTO;
            return globalScaResponseTO2;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<PaymentTO> getPaymentFromLedgers(SpiPayment payment, byte[] aspspConsentData) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentData);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            logger.info("Get payment by ID with type: {} and ID: {}", (Object)payment.getPaymentType(), (Object)payment.getPaymentId());
            logger.debug("Payment body: {}", (Object)payment);
            Optional<PaymentTO> optional = Optional.ofNullable((PaymentTO)this.paymentRestClient.getPaymentById(sca.getOperationObjectId()).getBody());
            return optional;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Get payment by ID failed: payment ID: {}, devMessage: {}", (Object)payment.getPaymentId(), (Object)devMessage);
            Optional<PaymentTO> optional = Optional.empty();
            return optional;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    private SpiPaymentExecutionResponse spiPaymentExecutionResponse(TransactionStatusTO transactionStatus) {
        return new SpiPaymentExecutionResponse(TransactionStatus.valueOf((String)transactionStatus.name()));
    }

    private TransactionStatus getTransactionStatus(TransactionStatusTO transactionStatusTO) {
        return Optional.ofNullable(transactionStatusTO).map(ts -> TransactionStatus.valueOf((String)ts.name())).orElse(null);
    }

    private <P extends SpiPayment> P setDebtorNameIfNull(P payment) {
        if (payment.getDebtorName() == null) {
            payment.setDebtorName(DEBTOR_NAME);
        }
        return payment;
    }

    private PaymentTO setDebtorNameIfNull(PaymentTO payment) {
        if (payment.getDebtorName() == null) {
            payment.setDebtorName(DEBTOR_NAME);
        }
        return payment;
    }
}

