package de.adorsys.aspsp.xs2a.connector.spi.impl.payment;

import de.adorsys.psd2.xs2a.core.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPeriodicPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiSinglePaymentInitiationResponse;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-28T16:26:31+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class Xs2aPaymentMapperImpl implements Xs2aPaymentMapper {

    @Override
    public SpiSinglePaymentInitiationResponse mapToSingle(SpiPaymentInitiationResponse source) {
        if ( source == null ) {
            return null;
        }

        SpiSinglePaymentInitiationResponse spiSinglePaymentInitiationResponse = new SpiSinglePaymentInitiationResponse();

        spiSinglePaymentInitiationResponse.setTransactionStatus( source.getTransactionStatus() );
        spiSinglePaymentInitiationResponse.setPaymentId( source.getPaymentId() );
        spiSinglePaymentInitiationResponse.setSpiTransactionFees( source.getSpiTransactionFees() );
        spiSinglePaymentInitiationResponse.setSpiTransactionFeeIndicator( source.getSpiTransactionFeeIndicator() );
        spiSinglePaymentInitiationResponse.setMultilevelScaRequired( source.isMultilevelScaRequired() );
        List<SpiAuthenticationObject> list = source.getScaMethods();
        if ( list != null ) {
            spiSinglePaymentInitiationResponse.setScaMethods( new ArrayList<SpiAuthenticationObject>( list ) );
        }
        spiSinglePaymentInitiationResponse.setChosenScaMethod( source.getChosenScaMethod() );
        spiSinglePaymentInitiationResponse.setChallengeData( source.getChallengeData() );
        spiSinglePaymentInitiationResponse.setPsuMessage( source.getPsuMessage() );
        Set<TppMessageInformation> set = source.getTppMessages();
        if ( set != null ) {
            spiSinglePaymentInitiationResponse.setTppMessages( new HashSet<TppMessageInformation>( set ) );
        }
        spiSinglePaymentInitiationResponse.setAspspAccountId( source.getAspspAccountId() );
        spiSinglePaymentInitiationResponse.setCurrencyConversionFee( source.getCurrencyConversionFee() );
        spiSinglePaymentInitiationResponse.setEstimatedTotalAmount( source.getEstimatedTotalAmount() );
        spiSinglePaymentInitiationResponse.setEstimatedInterbankSettlementAmount( source.getEstimatedInterbankSettlementAmount() );

        return spiSinglePaymentInitiationResponse;
    }

    @Override
    public SpiPeriodicPaymentInitiationResponse mapToPeriodic(SpiPaymentInitiationResponse source) {
        if ( source == null ) {
            return null;
        }

        SpiPeriodicPaymentInitiationResponse spiPeriodicPaymentInitiationResponse = new SpiPeriodicPaymentInitiationResponse();

        spiPeriodicPaymentInitiationResponse.setTransactionStatus( source.getTransactionStatus() );
        spiPeriodicPaymentInitiationResponse.setPaymentId( source.getPaymentId() );
        spiPeriodicPaymentInitiationResponse.setSpiTransactionFees( source.getSpiTransactionFees() );
        spiPeriodicPaymentInitiationResponse.setSpiTransactionFeeIndicator( source.getSpiTransactionFeeIndicator() );
        spiPeriodicPaymentInitiationResponse.setMultilevelScaRequired( source.isMultilevelScaRequired() );
        List<SpiAuthenticationObject> list = source.getScaMethods();
        if ( list != null ) {
            spiPeriodicPaymentInitiationResponse.setScaMethods( new ArrayList<SpiAuthenticationObject>( list ) );
        }
        spiPeriodicPaymentInitiationResponse.setChosenScaMethod( source.getChosenScaMethod() );
        spiPeriodicPaymentInitiationResponse.setChallengeData( source.getChallengeData() );
        spiPeriodicPaymentInitiationResponse.setPsuMessage( source.getPsuMessage() );
        Set<TppMessageInformation> set = source.getTppMessages();
        if ( set != null ) {
            spiPeriodicPaymentInitiationResponse.setTppMessages( new HashSet<TppMessageInformation>( set ) );
        }
        spiPeriodicPaymentInitiationResponse.setAspspAccountId( source.getAspspAccountId() );
        spiPeriodicPaymentInitiationResponse.setCurrencyConversionFee( source.getCurrencyConversionFee() );
        spiPeriodicPaymentInitiationResponse.setEstimatedTotalAmount( source.getEstimatedTotalAmount() );
        spiPeriodicPaymentInitiationResponse.setEstimatedInterbankSettlementAmount( source.getEstimatedInterbankSettlementAmount() );

        return spiPeriodicPaymentInitiationResponse;
    }
}
