package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.ledgers.middleware.api.domain.sca.ChallengeDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OtpFormatTO;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.OtpFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-28T16:26:31+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class ChallengeDataMapperImpl implements ChallengeDataMapper {

    @Override
    public ChallengeData toChallengeData(ChallengeDataTO to) {
        if ( to == null ) {
            return null;
        }

        ChallengeData challengeData = new ChallengeData();

        byte[] image = to.getImage();
        if ( image != null ) {
            challengeData.setImage( Arrays.copyOf( image, image.length ) );
        }
        List<String> list = to.getData();
        if ( list != null ) {
            challengeData.setData( new ArrayList<String>( list ) );
        }
        challengeData.setImageLink( to.getImageLink() );
        challengeData.setOtpMaxLength( to.getOtpMaxLength() );
        challengeData.setOtpFormat( otpFormatTOToOtpFormat( to.getOtpFormat() ) );
        challengeData.setAdditionalInformation( to.getAdditionalInformation() );

        return challengeData;
    }

    protected OtpFormat otpFormatTOToOtpFormat(OtpFormatTO otpFormatTO) {
        if ( otpFormatTO == null ) {
            return null;
        }

        OtpFormat otpFormat;

        switch ( otpFormatTO ) {
            case CHARACTERS: otpFormat = OtpFormat.CHARACTERS;
            break;
            case INTEGER: otpFormat = OtpFormat.INTEGER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + otpFormatTO );
        }

        return otpFormat;
    }
}
