/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import feign.FeignException;
import feign.Request;
import feign.Response;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.ResourceAccessException;

public class FeignExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(FeignExceptionHandler.class);

    private FeignExceptionHandler() {
    }

    public static TppMessage getFailureMessage(FeignException e, MessageErrorCode errorCode) {
        logger.error(e.getMessage(), (Throwable)e);
        if (e.getCause() instanceof ConnectException) {
            throw new ResourceAccessException(e.getMessage());
        }
        switch (HttpStatus.valueOf((int)e.status())) {
            case INTERNAL_SERVER_ERROR: {
                return new TppMessage(MessageErrorCode.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            case UNAUTHORIZED: {
                return new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0]);
            }
        }
        return new TppMessage(errorCode, new Object[0]);
    }

    public static TppMessage getFailureMessage(FeignException e, MessageErrorCode errorCode, String errorMessageAspsp) {
        return FeignExceptionHandler.shouldUseNormalErrorMessage(e, errorCode, errorMessageAspsp) ? FeignExceptionHandler.getFailureMessage(e, errorCode) : new TppMessage(errorCode, errorMessageAspsp, new Object[0]);
    }

    private static boolean shouldUseNormalErrorMessage(FeignException e, MessageErrorCode errorCode, String errorMessageAspsp) {
        return StringUtils.isBlank((CharSequence)errorMessageAspsp) || HttpStatus.valueOf((int)e.status()) == HttpStatus.BAD_REQUEST && errorCode == MessageErrorCode.PAYMENT_FAILED;
    }

    public static FeignException getException(HttpStatus httpStatus, String message) {
        return FeignException.errorStatus((String)message, (Response)FeignExceptionHandler.error(httpStatus));
    }

    static Response error(HttpStatus httpStatus) {
        return Response.builder().status(httpStatus.value()).request(Request.create((Request.HttpMethod)Request.HttpMethod.GET, (String)"", Collections.emptyMap(), null, (Charset)Charset.defaultCharset(), null)).headers(Collections.emptyMap()).build();
    }
}

