/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.service;

import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransactionLinks;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class TransactionLinksService {
    private static final String PAGE_INDEX_QUERY_PARAM = "pageIndex";
    private final HttpServletRequest request;

    public SpiTransactionLinks buildSpiTransactionLinks(int currentPage, int itemsPerPage, CustomPageImpl<TransactionTO> transactionsOnPage) {
        if (transactionsOnPage == null) {
            return null;
        }
        String uri = this.request.getRequestURI();
        UriComponentsBuilder firstPage = UriComponentsBuilder.fromPath((String)uri).queryParam(PAGE_INDEX_QUERY_PARAM, new Object[]{0});
        UriComponentsBuilder nextPage = UriComponentsBuilder.fromPath((String)uri).queryParam(PAGE_INDEX_QUERY_PARAM, new Object[]{currentPage + 1});
        UriComponentsBuilder previousPage = UriComponentsBuilder.fromPath((String)uri).queryParam(PAGE_INDEX_QUERY_PARAM, new Object[]{currentPage - 1});
        UriComponentsBuilder lastPage = UriComponentsBuilder.fromPath((String)uri).queryParam(PAGE_INDEX_QUERY_PARAM, new Object[]{transactionsOnPage.getTotalPages() - 1});
        Arrays.asList(firstPage, nextPage, previousPage, lastPage).forEach(u -> u.queryParam("itemsPerPage", new Object[]{itemsPerPage}));
        String first = transactionsOnPage.isFirstPage() ? null : firstPage.toUriString();
        String next = transactionsOnPage.isLastPage() ? null : nextPage.toUriString();
        String previous = transactionsOnPage.isFirstPage() ? null : previousPage.toUriString();
        String last = transactionsOnPage.isLastPage() ? null : lastPage.toUriString();
        return new SpiTransactionLinks(first, next, previous, last);
    }

    public TransactionLinksService(HttpServletRequest request) {
        this.request = request;
    }
}

