/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LoginAttemptAspspConsentDataService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import java.io.IOException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AspspConsentDataService {
    private final ObjectMapper objectMapper;
    private final ScaResponseMapper scaResponseMapper;
    private final LoginAttemptAspspConsentDataService loginAttemptAspspConsentDataService;

    public byte[] store(GlobalScaResponseTO response) {
        return this.store(response, true);
    }

    public byte[] store(GlobalScaResponseTO response, boolean checkCredentials) {
        if (checkCredentials && response.getBearerToken() == null) {
            throw new IllegalStateException("Missing credentials, response must contain a bearer token by default.");
        }
        try {
            return this.objectMapper.writeValueAsBytes((Object)response);
        }
        catch (IOException e) {
            throw FeignExceptionHandler.getException(HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    public GlobalScaResponseTO response(byte[] aspspConsentData) {
        return this.response(aspspConsentData, true);
    }

    public GlobalScaResponseTO response(byte[] aspspConsentData, boolean checkCredentials) {
        try {
            GlobalScaResponseTO sca = this.fromBytes(aspspConsentData);
            this.checkBearerTokenPresent(checkCredentials, sca);
            return sca;
        }
        catch (IOException e) {
            throw FeignExceptionHandler.getException(HttpStatus.UNAUTHORIZED, e.getMessage());
        }
    }

    public LoginAttemptAspspConsentDataService getLoginAttemptAspspConsentDataService() {
        return this.loginAttemptAspspConsentDataService;
    }

    private void checkBearerTokenPresent(boolean checkCredentials, GlobalScaResponseTO sca) {
        if (checkCredentials && sca.getBearerToken() == null) {
            throw FeignExceptionHandler.getException(HttpStatus.UNAUTHORIZED, "Missing credentials. Expecting a bearer token in the consent data object.");
        }
    }

    private String readType(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.objectMapper.readTree(tokenBytes);
        JsonNode objectType = jsonNode.get("objectType");
        if (objectType == null) {
            return null;
        }
        return objectType.textValue();
    }

    private GlobalScaResponseTO fromBytes(byte[] tokenBytes) throws IOException {
        String type = this.readType(tokenBytes);
        if (type == null || GlobalScaResponseTO.class.getSimpleName().equals(type)) {
            return (GlobalScaResponseTO)this.objectMapper.readValue(tokenBytes, GlobalScaResponseTO.class);
        }
        if (SCAConsentResponseTO.class.getSimpleName().equals(type)) {
            SCAConsentResponseTO scaConsentResponseTO = (SCAConsentResponseTO)this.objectMapper.readValue(tokenBytes, SCAConsentResponseTO.class);
            return this.scaResponseMapper.toGlobalScaResponse(scaConsentResponseTO);
        }
        if (SCAPaymentResponseTO.class.getSimpleName().equals(type)) {
            SCAPaymentResponseTO scaPaymentResponseTO = (SCAPaymentResponseTO)this.objectMapper.readValue(tokenBytes, SCAPaymentResponseTO.class);
            return this.scaResponseMapper.toGlobalScaResponse(scaPaymentResponseTO);
        }
        return null;
    }

    public AspspConsentDataService(ObjectMapper objectMapper, ScaResponseMapper scaResponseMapper, LoginAttemptAspspConsentDataService loginAttemptAspspConsentDataService) {
        this.objectMapper = objectMapper;
        this.scaResponseMapper = scaResponseMapper;
        this.loginAttemptAspspConsentDataService = loginAttemptAspspConsentDataService;
    }
}

