/*
 * Copyright 2018-2020 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.adorsys.aspsp.xs2a.connector.spi.impl;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Example:
 * {
 * "operationObjectId":"12345",
 * "loginFailedCount":1,
 * "objectType":"LoginAttemptResponse"
 * }"
 */
@Data
@NoArgsConstructor
public class LoginAttemptResponse {
    private int loginFailedCount = 1;
    private String objectType;

    public void incrementLoginFailedCount() {
        ++this.loginFailedCount;
    }

    public String getObjectType() {
        return this.getClass().getSimpleName();
    }
}
