/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.AisConsentMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaResponseMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LedgersErrorCode;
import de.adorsys.aspsp.xs2a.connector.spi.impl.MultilevelScaService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.AbstractAuthorisationSpi;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.confirmation.ConsentAuthConfirmationCodeService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.ConsentRestClient;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiConsentStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiInitiatePiisConsentResponse;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiVerifyScaAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.piis.SpiPiisConsent;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PiisConsentSpi;
import feign.FeignException;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PiisConsentSpiImpl
extends AbstractAuthorisationSpi<SpiPiisConsent>
implements PiisConsentSpi {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentSpiImpl.class);
    private static final String SCA_STATUS_LOG = "SCA status is {}";
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final MultilevelScaService multilevelScaService;
    private final FeignExceptionReader feignExceptionReader;
    private final RedirectScaRestClient redirectScaRestClient;
    private final ConsentRestClient consentRestClient;
    private final AisConsentMapper aisConsentMapper;
    private final ScaResponseMapper scaResponseMapper;
    private final ConsentAuthConfirmationCodeService authConfirmationCodeService;

    @Autowired
    public PiisConsentSpiImpl(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, FeignExceptionReader feignExceptionReader, MultilevelScaService multilevelScaService, RedirectScaRestClient redirectScaRestClient, KeycloakTokenService keycloakTokenService, ConsentRestClient consentRestClient, AisConsentMapper aisConsentMapper, ScaResponseMapper scaResponseMapper, ConsentAuthConfirmationCodeService authConfirmationCodeService) {
        super(authRequestInterceptor, consentDataService, authorisationService, scaMethodConverter, feignExceptionReader, keycloakTokenService, redirectScaRestClient);
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.multilevelScaService = multilevelScaService;
        this.feignExceptionReader = feignExceptionReader;
        this.redirectScaRestClient = redirectScaRestClient;
        this.consentRestClient = consentRestClient;
        this.aisConsentMapper = aisConsentMapper;
        this.scaResponseMapper = scaResponseMapper;
        this.authConfirmationCodeService = authConfirmationCodeService;
    }

    @Override
    protected GlobalScaResponseTO getScaObjectResponse(@NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, boolean checkCredentials) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        return this.consentDataService.response(aspspConsentData, checkCredentials);
    }

    @Override
    protected String getBusinessObjectId(SpiPiisConsent businessObject) {
        return businessObject.getId();
    }

    @Override
    protected OpTypeTO getOpType() {
        return OpTypeTO.CONSENT;
    }

    @Override
    protected TppMessage getAuthorisePsuFailureMessage(SpiPiisConsent businessObject) {
        log.error("Initiate consent failed: consent ID {}", (Object)businessObject.getId());
        return new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GlobalScaResponseTO initiateBusinessObject(SpiPiisConsent piisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, String authorisationId) {
        try {
            SpiAccountConsent mockedConsent = new SpiAccountConsent();
            SpiAccountAccess access = new SpiAccountAccess();
            access.setAccounts(Collections.singletonList(piisConsent.getAccount()));
            mockedConsent.setAccess(access);
            TppInfo tppInfo = new TppInfo();
            tppInfo.setAuthorityId("TPP ID");
            tppInfo.setAuthorisationNumber("TPP ID");
            mockedConsent.setTppInfo(tppInfo);
            mockedConsent.setId(piisConsent.getId());
            ResponseEntity initiateConsentResponse = this.consentRestClient.initiateAisConsent(piisConsent.getId(), this.aisConsentMapper.mapToAisConsent(mockedConsent));
            if (initiateConsentResponse == null || initiateConsentResponse.getBody() == null) {
                log.error("Initiate PIIS consent response or bearer token is NULL");
                GlobalScaResponseTO globalScaResponseTO = null;
                return globalScaResponseTO;
            }
            SCAConsentResponseTO consentResponse = (SCAConsentResponseTO)initiateConsentResponse.getBody();
            if (consentResponse.getBearerToken() != null) {
                this.authRequestInterceptor.setAccessToken(consentResponse.getBearerToken().getAccess_token());
            }
            consentResponse.setAuthorisationId(authorisationId);
            if (consentResponse.getScaStatus() == ScaStatusTO.EXEMPTED) {
                GlobalScaResponseTO globalScaResponseTO = this.scaResponseMapper.toGlobalScaResponse(consentResponse);
                return globalScaResponseTO;
            }
            StartScaOprTO startScaOprTO = new StartScaOprTO(piisConsent.getId(), OpTypeTO.CONSENT);
            startScaOprTO.setAuthorisationId(authorisationId);
            ResponseEntity consentScaResponse = this.redirectScaRestClient.startSca(startScaOprTO);
            GlobalScaResponseTO globalScaResponseTO = (GlobalScaResponseTO)consentScaResponse.getBody();
            return globalScaResponseTO;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    @Override
    protected boolean isFirstInitiationOfMultilevelSca(SpiPiisConsent businessObject, GlobalScaResponseTO scaConsentResponseTO) {
        return !scaConsentResponseTO.isMultilevelScaRequired() || businessObject.getPsuData().size() <= 1;
    }

    @Override
    protected GlobalScaResponseTO executeBusinessObject(SpiPiisConsent businessObject) {
        return null;
    }

    @Override
    protected void updateStatusInCms(String businessObjectId, SpiAspspConsentDataProvider aspspConsentDataProvider) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiVerifyScaAuthorisationResponse> verifyScaAuthorisation(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPiisConsent spiPiisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            GlobalScaResponseTO sca = this.consentDataService.response(aspspConsentDataProvider.loadAspspConsentData());
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity authorizeConsentResponse = this.redirectScaRestClient.validateScaCode(sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            if (authorizeConsentResponse == null || authorizeConsentResponse.getBody() == null) {
                log.error("Validate SCA code response is NULL");
                SpiResponse spiResponse = SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR, new Object[0])).build();
                return spiResponse;
            }
            GlobalScaResponseTO globalScaResponse = (GlobalScaResponseTO)authorizeConsentResponse.getBody();
            String scaStatusName = sca.getScaStatus().name();
            log.info(SCA_STATUS_LOG, (Object)scaStatusName);
            aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(globalScaResponse, !globalScaResponse.isPartiallyAuthorised()));
            SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(this.mapToConsentStatus(globalScaResponse))).build();
            return spiResponse;
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            log.error("Verify sca authorisation failed: consent ID {}, devMessage {}", (Object)spiPiisConsent.getId(), (Object)devMessage);
            LedgersErrorCode errorCode = this.feignExceptionReader.getLedgersErrorCode(feignException);
            if (LedgersErrorCode.SCA_VALIDATION_ATTEMPT_FAILED.equals((Object)errorCode)) {
                SpiResponse spiResponse = SpiResponse.builder().payload((Object)new SpiVerifyScaAuthorisationResponse(spiPiisConsent.getConsentStatus(), SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
                return spiResponse;
            }
            SpiResponse spiResponse = SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
            return spiResponse;
        }
        finally {
            this.authRequestInterceptor.setAccessToken(null);
        }
    }

    public SpiResponse<SpiInitiatePiisConsentResponse> initiatePiisConsent(@NotNull SpiContextData contextData, SpiPiisConsent spiPiisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        boolean multilevelScaRequired;
        SpiInitiatePiisConsentResponse spiInitiatePiisConsentResponse = new SpiInitiatePiisConsentResponse();
        spiInitiatePiisConsentResponse.setSpiAccountReference(spiPiisConsent.getAccount());
        try {
            multilevelScaRequired = this.multilevelScaService.isMultilevelScaRequired(contextData.getPsuData(), Collections.singleton(spiPiisConsent.getAccount()));
        }
        catch (FeignException e) {
            log.error("Error during REST call for consent initiation to ledgers for account multilevel checking, PSU ID: {}", (Object)contextData.getPsuData().getPsuId());
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.FORMAT_ERROR_UNKNOWN_ACCOUNT, new Object[0])).build();
        }
        GlobalScaResponseTO response = new GlobalScaResponseTO();
        response.setOpType(OpTypeTO.CONSENT);
        response.setScaStatus(ScaStatusTO.STARTED);
        response.setMultilevelScaRequired(multilevelScaRequired);
        aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(response, false));
        spiInitiatePiisConsentResponse.setMultilevelScaRequired(multilevelScaRequired);
        return SpiResponse.builder().payload((Object)spiInitiatePiisConsentResponse).build();
    }

    public SpiResponse<SpiConsentStatusResponse> getConsentStatus(@NotNull SpiContextData contextData, @NotNull SpiPiisConsent spiPiisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return SpiResponse.builder().payload((Object)new SpiConsentStatusResponse(spiPiisConsent.getConsentStatus(), null)).build();
    }

    public SpiResponse<SpiResponse.VoidResponse> revokePiisConsent(@NotNull SpiContextData contextData, SpiPiisConsent spiPiisConsent, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
    }

    @NotNull
    public SpiResponse<SpiConsentConfirmationCodeValidationResponse> checkConfirmationCode(@NotNull SpiContextData spiContextData, @NotNull SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        return this.authConfirmationCodeService.checkConfirmationCode(spiCheckConfirmationCodeRequest, spiAspspConsentDataProvider);
    }

    @NotNull
    public SpiResponse<SpiConsentConfirmationCodeValidationResponse> notifyConfirmationCodeValidation(@NotNull SpiContextData spiContextData, boolean confirmationCodeValidationResult, @NotNull SpiPiisConsent businessObject, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        return this.authConfirmationCodeService.completeAuthConfirmation(confirmationCodeValidationResult, spiAspspConsentDataProvider);
    }

    public boolean checkConfirmationCodeInternally(String authorisationId, String confirmationCode, String scaAuthenticationData, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.authConfirmationCodeService.checkConfirmationCodeInternally(authorisationId, confirmationCode, scaAuthenticationData, aspspConsentDataProvider);
    }

    ConsentStatus mapToConsentStatus(GlobalScaResponseTO globalScaResponse) {
        if (globalScaResponse != null && globalScaResponse.isPartiallyAuthorised() && ScaStatusTO.FINALISED.equals((Object)globalScaResponse.getScaStatus())) {
            return ConsentStatus.PARTIALLY_AUTHORISED;
        }
        return ConsentStatus.VALID;
    }
}

