/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LoginAttemptAspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.LoginAttemptResponse;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.RedirectScaRestClient;
import de.adorsys.psd2.xs2a.core.authorisation.AuthenticationObject;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationDecoupledScaResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAvailableScaMethodsResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaInformationResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaStatusResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import feign.FeignException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class AbstractAuthorisationSpi<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorisationSpi.class);
    private static final String DECOUPLED_PSU_MESSAGE = "Please check your app to continue...";
    private static final String LOGIN_AMOUNT_ATTEMPTS_REMAINING_MESSAGE = "You have %s attempts to enter valid credentials";
    private static final String PSU_MESSAGE = "Mocked PSU message from SPI.";
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final GeneralAuthorisationService authorisationService;
    private final ScaMethodConverter scaMethodConverter;
    private final FeignExceptionReader feignExceptionReader;
    private final KeycloakTokenService keycloakTokenService;
    private final RedirectScaRestClient redirectScaRestClient;

    protected ResponseEntity<GlobalScaResponseTO> getSelectMethodResponse(@NotNull String authenticationMethodId, GlobalScaResponseTO sca) {
        ResponseEntity scaResponse = this.redirectScaRestClient.selectMethod(sca.getAuthorisationId(), authenticationMethodId);
        return scaResponse.getStatusCode() == HttpStatus.OK ? ResponseEntity.ok((Object)((GlobalScaResponseTO)scaResponse.getBody())) : ResponseEntity.badRequest().build();
    }

    protected GlobalScaResponseTO getScaObjectResponse(SpiAspspConsentDataProvider aspspConsentDataProvider, boolean checkCredentials) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        return this.consentDataService.response(aspspConsentData, checkCredentials);
    }

    protected abstract String getBusinessObjectId(T var1);

    protected abstract OpTypeTO getOpType();

    protected abstract TppMessage getAuthorisePsuFailureMessage(T var1);

    protected abstract GlobalScaResponseTO initiateBusinessObject(T var1, @NotNull SpiAspspConsentDataProvider var2, String var3);

    protected abstract boolean isFirstInitiationOfMultilevelSca(T var1, GlobalScaResponseTO var2);

    protected abstract GlobalScaResponseTO executeBusinessObject(T var1);

    protected abstract void updateStatusInCms(String var1, SpiAspspConsentDataProvider var2);

    protected String generatePsuMessage(@NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiAuthorizationCodeResult> response) {
        return DECOUPLED_PSU_MESSAGE;
    }

    protected boolean validateStatuses(T businessObject, GlobalScaResponseTO sca) {
        return false;
    }

    public SpiResponse<SpiPsuAuthorisationResponse> authorisePsu(@NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull SpiPsuData psuLoginData, String password, T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO scaResponseTO;
        try {
            BearerTokenTO loginToken = this.keycloakTokenService.login(contextData.getPsuData().getPsuId(), password);
            this.authRequestInterceptor.setAccessToken(loginToken.getAccess_token());
        }
        catch (FeignException feignException) {
            return this.handleLoginFailureError(businessObject, aspspConsentDataProvider, feignException);
        }
        try {
            scaResponseTO = this.initiateBusinessObject(businessObject, aspspConsentDataProvider, authorisationId);
        }
        catch (FeignException feignException) {
            return this.resolveErrorResponse(businessObject, feignException);
        }
        if (scaResponseTO.getScaStatus() == ScaStatusTO.EXEMPTED && this.isFirstInitiationOfMultilevelSca(businessObject, scaResponseTO)) {
            try {
                this.authRequestInterceptor.setAccessToken(scaResponseTO.getBearerToken().getAccess_token());
                GlobalScaResponseTO executionResponse = this.executeBusinessObject(businessObject);
                if (executionResponse == null) {
                    executionResponse = scaResponseTO;
                }
                executionResponse.setBearerToken(scaResponseTO.getBearerToken());
                executionResponse.setScaStatus(scaResponseTO.getScaStatus());
                aspspConsentDataProvider.updateAspspConsentData(this.consentDataService.store(executionResponse));
                String scaStatusName = scaResponseTO.getScaStatus().name();
                log.info("SCA status is: {}", (Object)scaStatusName);
                return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(true, SpiAuthorisationStatus.SUCCESS)).build();
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                log.info("Processing of successful authorisation failed: devMessage '{}'", (Object)devMessage);
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR)).build();
            }
        }
        log.info("Authorising user with login: {}", (Object)psuLoginData.getPsuId());
        SpiResponse<SpiPsuAuthorisationResponse> authorisationResponse = this.authorisationService.authorisePsuInternal(this.getBusinessObjectId(businessObject), authorisationId, this.getOpType(), scaResponseTO, aspspConsentDataProvider);
        if (this.isFirstInitiationOfMultilevelSca(businessObject, scaResponseTO)) {
            this.updateStatusInCms(this.getBusinessObjectId(businessObject), aspspConsentDataProvider);
        }
        return authorisationResponse;
    }

    protected SpiResponse<SpiPsuAuthorisationResponse> resolveErrorResponse(T businessObject, FeignException feignException) {
        String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
        log.info("Initiate business object error: business object ID: {}, devMessage: {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
        return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.FAILURE)).build();
    }

    public SpiResponse<SpiAvailableScaMethodsResponse> requestAvailableScaMethods(@NotNull SpiContextData contextData, T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            List<ScaUserDataTO> scaMethods;
            GlobalScaResponseTO sca = this.getScaObjectResponse(aspspConsentDataProvider, true);
            if (this.validateStatuses(businessObject, sca)) {
                return SpiResponse.builder().payload((Object)new SpiAvailableScaMethodsResponse(Collections.emptyList())).build();
            }
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            if (sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
                return SpiResponse.builder().payload((Object)new SpiAvailableScaMethodsResponse(true, Collections.emptyList())).build();
            }
            ResponseEntity availableMethodsResponse = this.redirectScaRestClient.getSCA(sca.getAuthorisationId());
            List<Object> list = scaMethods = availableMethodsResponse != null ? Optional.ofNullable((GlobalScaResponseTO)availableMethodsResponse.getBody()).map(GlobalScaResponseTO::getScaMethods).orElse(Collections.emptyList()) : Collections.emptyList();
            if (!scaMethods.isEmpty()) {
                List<AuthenticationObject> authenticationObjects = this.scaMethodConverter.toAuthenticationObjectList(scaMethods);
                return SpiResponse.builder().payload((Object)new SpiAvailableScaMethodsResponse(authenticationObjects)).build();
            }
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            log.error("Request available SCA methods failed: business object ID: {}, devMessage: {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
            return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_SCA_METHODS)).build();
        }
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SCA_METHOD_UNKNOWN_PROCESS_MISMATCH, new Object[0])).build();
    }

    protected Optional<List<ScaUserDataTO>> getScaMethods(GlobalScaResponseTO sca) {
        return Optional.ofNullable(sca.getScaMethods());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SpiResponse<SpiAuthorizationCodeResult> requestAuthorisationCode(@NotNull SpiContextData contextData, @NotNull String authenticationMethodId, @NotNull T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        GlobalScaResponseTO sca = this.getScaObjectResponse(aspspConsentDataProvider, true);
        if (EnumSet.of(ScaStatusTO.PSUIDENTIFIED, ScaStatusTO.PSUAUTHENTICATED).contains(sca.getScaStatus())) {
            try {
                this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
                ResponseEntity<GlobalScaResponseTO> selectMethodResponse = this.getSelectMethodResponse(authenticationMethodId, sca);
                GlobalScaResponseTO authCodeResponse = (GlobalScaResponseTO)selectMethodResponse.getBody();
                if (authCodeResponse != null && authCodeResponse.getBearerToken() == null) {
                    authCodeResponse.setBearerToken(sca.getBearerToken());
                }
                SpiResponse<SpiAuthorizationCodeResult> spiResponse = this.authorisationService.returnScaMethodSelection(aspspConsentDataProvider, authCodeResponse, authenticationMethodId);
                return spiResponse;
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                log.error("Request authorisation code failed: business object ID: {}, devMessage: {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
                TppMessage errorMessage = new TppMessage(this.getMessageErrorCodeByStatus(feignException.status()), new Object[0]);
                SpiResponse spiResponse = SpiResponse.builder().error(errorMessage).build();
                return spiResponse;
            }
            finally {
                this.authRequestInterceptor.setAccessToken(null);
            }
        }
        return this.authorisationService.getResponseIfScaSelected(aspspConsentDataProvider, sca, authenticationMethodId);
    }

    @NotNull
    public SpiResponse<SpiAuthorisationDecoupledScaResponse> startScaDecoupled(@NotNull SpiContextData contextData, @NotNull String authorisationId, @Nullable String authenticationMethodId, @NotNull T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (authenticationMethodId == null) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.SERVICE_NOT_SUPPORTED, new Object[0])).build();
        }
        SpiResponse<SpiAuthorizationCodeResult> response = this.requestAuthorisationCode(contextData, authenticationMethodId, businessObject, aspspConsentDataProvider);
        if (response.hasError()) {
            return SpiResponse.builder().error(response.getErrors()).build();
        }
        String psuMessage = this.generatePsuMessage(contextData, authorisationId, aspspConsentDataProvider, response);
        return SpiResponse.builder().payload((Object)new SpiAuthorisationDecoupledScaResponse(((SpiAuthorizationCodeResult)response.getPayload()).getScaStatus(), psuMessage)).build();
    }

    public SpiResponse<SpiScaInformationResponse> getScaInformation(@NotNull SpiContextData spiContextData, @NotNull String authorisationId, @NotNull SpiAspspConsentDataProvider spiAspspConsentDataProvider) {
        return SpiResponse.builder().payload((Object)new SpiScaInformationResponse(Boolean.valueOf(false), PSU_MESSAGE)).build();
    }

    public SpiResponse<SpiScaStatusResponse> getScaStatus(@NotNull ScaStatus scaStatus, @NotNull SpiContextData contextData, @NotNull String authorisationId, @NotNull T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return SpiResponse.builder().payload((Object)new SpiScaStatusResponse(scaStatus, Boolean.valueOf(false), PSU_MESSAGE)).build();
    }

    private SpiResponse<SpiPsuAuthorisationResponse> handleLoginFailureError(T businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, FeignException feignException) {
        String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
        log.info("Login to IDP in authorise PSU failed: business object ID: {}, devMessage: {}", (Object)this.getBusinessObjectId(businessObject), (Object)devMessage);
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        LoginAttemptAspspConsentDataService loginAttemptAspspConsentDataService = this.consentDataService.getLoginAttemptAspspConsentDataService();
        LoginAttemptResponse loginAttemptResponse = loginAttemptAspspConsentDataService.response(aspspConsentData);
        if (loginAttemptResponse == null) {
            loginAttemptResponse = new LoginAttemptResponse();
        }
        int remainingLoginAttempts = loginAttemptAspspConsentDataService.getRemainingLoginAttempts(loginAttemptResponse.getLoginFailedCount());
        loginAttemptResponse.incrementLoginFailedCount();
        aspspConsentDataProvider.updateAspspConsentData(loginAttemptAspspConsentDataService.store(loginAttemptResponse));
        if (remainingLoginAttempts > 0) {
            devMessage = String.format(LOGIN_AMOUNT_ATTEMPTS_REMAINING_MESSAGE, remainingLoginAttempts);
            log.info(devMessage);
            return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.ATTEMPT_FAILURE)).error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.PSU_CREDENTIALS_INVALID, devMessage)).build();
        }
        return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.FAILURE)).build();
    }

    private MessageErrorCode getMessageErrorCodeByStatus(int status) {
        if (status == 501) {
            return MessageErrorCode.SCA_METHOD_UNKNOWN;
        }
        if (Arrays.asList(400, 401, 403).contains(status)) {
            return MessageErrorCode.FORMAT_ERROR;
        }
        if (status == 404) {
            return MessageErrorCode.PSU_CREDENTIALS_INVALID;
        }
        return MessageErrorCode.INTERNAL_SERVER_ERROR;
    }

    public AbstractAuthorisationSpi(AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, ScaMethodConverter scaMethodConverter, FeignExceptionReader feignExceptionReader, KeycloakTokenService keycloakTokenService, RedirectScaRestClient redirectScaRestClient) {
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.authorisationService = authorisationService;
        this.scaMethodConverter = scaMethodConverter;
        this.feignExceptionReader = feignExceptionReader;
        this.keycloakTokenService = keycloakTokenService;
        this.redirectScaRestClient = redirectScaRestClient;
    }
}

