/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.account;

import de.adorsys.aspsp.xs2a.connector.account.IbanAccountReference;
import de.adorsys.aspsp.xs2a.connector.mock.IbanResolverMockService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.rest.client.AccountRestClient;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAdditionalInformationAccess;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.consent.SpiAccountAccess;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class OwnerNameService {
    private static final Logger log = LoggerFactory.getLogger(OwnerNameService.class);
    private final AccountRestClient accountRestClient;
    private final IbanResolverMockService ibanResolverMockService;

    public boolean shouldContainOwnerName(IbanAccountReference ibanAccountReference, SpiAccountAccess accountAccess) {
        SpiAdditionalInformationAccess spiAdditionalInformationAccess = accountAccess.getSpiAdditionalInformationAccess();
        if (spiAdditionalInformationAccess != null && spiAdditionalInformationAccess.getOwnerName() != null) {
            List ownerName = spiAdditionalInformationAccess.getOwnerName();
            return ownerName.isEmpty() || this.containsAccountReferenceWithIban(ownerName, ibanAccountReference.getIban(), ibanAccountReference.getCurrency());
        }
        AccountAccessType allAccountsWithOwnerName = AccountAccessType.ALL_ACCOUNTS_WITH_OWNER_NAME;
        List<AccountAccessType> accountAccessTypes = Arrays.asList(accountAccess.getAvailableAccounts(), accountAccess.getAvailableAccountsWithBalance(), accountAccess.getAllPsd2());
        return accountAccessTypes.contains(allAccountsWithOwnerName);
    }

    public SpiAccountDetails enrichAccountDetailsWithOwnerName(SpiAccountDetails accountDetails) {
        String accountOwnerNameFromLedgers = this.getAccountOwnerNameFromLedgers(accountDetails.getResourceId());
        accountDetails.setOwnerName(accountOwnerNameFromLedgers);
        return accountDetails;
    }

    public SpiCardAccountDetails enrichCardAccountDetailsWithOwnerName(SpiCardAccountDetails cardAccountDetails) {
        String accountOwnerNameFromLedgers = this.getAccountOwnerNameFromLedgers(cardAccountDetails.getResourceId());
        cardAccountDetails.setOwnerName(accountOwnerNameFromLedgers);
        return cardAccountDetails;
    }

    private boolean containsAccountReferenceWithIban(List<SpiAccountReference> references, @NotNull String iban, Currency currency) {
        return references.stream().filter(reference -> iban.equals(this.getIbanFromAccessReference((SpiAccountReference)reference))).anyMatch(reference -> reference.getCurrency() == null || reference.getCurrency().equals(currency));
    }

    private String getAccountOwnerNameFromLedgers(String resourceId) {
        ResponseEntity additionalAccountInfo = this.accountRestClient.getAdditionalAccountInfo(AccountIdentifierTypeTO.ACCOUNT_ID, resourceId);
        List additionalAccountInformationList = (List)additionalAccountInfo.getBody();
        if (CollectionUtils.isEmpty((Collection)additionalAccountInformationList)) {
            return null;
        }
        return additionalAccountInformationList.stream().map(AdditionalAccountInformationTO::getAccountOwnerName).collect(Collectors.joining(", "));
    }

    private String getIbanFromAccessReference(SpiAccountReference reference) {
        String iban = reference.getIban();
        return iban != null ? iban : this.ibanResolverMockService.handleIbanByAccountReference(reference);
    }

    public OwnerNameService(AccountRestClient accountRestClient, IbanResolverMockService ibanResolverMockService) {
        this.accountRestClient = accountRestClient;
        this.ibanResolverMockService = ibanResolverMockService;
    }
}

