/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OAuthConfiguration {
    @Value(value="${oauth.integrated.ais.suffix:?consentId={encrypted-consent-id}&redirectId={redirect-id}}")
    private String aisIntegratedOauthSuffix;
    @Value(value="${oauth.integrated.pis.suffix:?paymentId={encrypted-payment-id}&redirectId={redirect-id}}")
    private String pisIntegratedOauthSuffix;
    @Value(value="${oauth.integrated.pis.suffix:?piisConsentId={encrypted-consent-id}&redirectId={redirect-id}}")
    private String piisIntegratedOauthSuffix;
    @Value(value="${oauth.pre-step.ais.suffix:&token=}")
    private String aisPreStepOauthSuffix;
    @Value(value="${oauth.pre-step.pis.suffix:&token=}")
    private String pisPreStepOauthSuffix;

    public String getIntegratedOauthSuffix(ServiceType serviceType) {
        if (serviceType == ServiceType.AIS) {
            return this.aisIntegratedOauthSuffix;
        }
        if (serviceType == ServiceType.PIS) {
            return this.pisIntegratedOauthSuffix;
        }
        if (serviceType == ServiceType.PIIS) {
            return this.piisIntegratedOauthSuffix;
        }
        return "";
    }

    public String getAisIntegratedOauthSuffix() {
        return this.aisIntegratedOauthSuffix;
    }

    public String getPisIntegratedOauthSuffix() {
        return this.pisIntegratedOauthSuffix;
    }

    public String getPiisIntegratedOauthSuffix() {
        return this.piisIntegratedOauthSuffix;
    }

    public String getAisPreStepOauthSuffix() {
        return this.aisPreStepOauthSuffix;
    }

    public String getPisPreStepOauthSuffix() {
        return this.pisPreStepOauthSuffix;
    }

    public void setAisIntegratedOauthSuffix(String aisIntegratedOauthSuffix) {
        this.aisIntegratedOauthSuffix = aisIntegratedOauthSuffix;
    }

    public void setPisIntegratedOauthSuffix(String pisIntegratedOauthSuffix) {
        this.pisIntegratedOauthSuffix = pisIntegratedOauthSuffix;
    }

    public void setPiisIntegratedOauthSuffix(String piisIntegratedOauthSuffix) {
        this.piisIntegratedOauthSuffix = piisIntegratedOauthSuffix;
    }

    public void setAisPreStepOauthSuffix(String aisPreStepOauthSuffix) {
        this.aisPreStepOauthSuffix = aisPreStepOauthSuffix;
    }

    public void setPisPreStepOauthSuffix(String pisPreStepOauthSuffix) {
        this.pisPreStepOauthSuffix = pisPreStepOauthSuffix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthConfiguration)) {
            return false;
        }
        OAuthConfiguration other = (OAuthConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$aisIntegratedOauthSuffix = this.getAisIntegratedOauthSuffix();
        String other$aisIntegratedOauthSuffix = other.getAisIntegratedOauthSuffix();
        if (this$aisIntegratedOauthSuffix == null ? other$aisIntegratedOauthSuffix != null : !this$aisIntegratedOauthSuffix.equals(other$aisIntegratedOauthSuffix)) {
            return false;
        }
        String this$pisIntegratedOauthSuffix = this.getPisIntegratedOauthSuffix();
        String other$pisIntegratedOauthSuffix = other.getPisIntegratedOauthSuffix();
        if (this$pisIntegratedOauthSuffix == null ? other$pisIntegratedOauthSuffix != null : !this$pisIntegratedOauthSuffix.equals(other$pisIntegratedOauthSuffix)) {
            return false;
        }
        String this$piisIntegratedOauthSuffix = this.getPiisIntegratedOauthSuffix();
        String other$piisIntegratedOauthSuffix = other.getPiisIntegratedOauthSuffix();
        if (this$piisIntegratedOauthSuffix == null ? other$piisIntegratedOauthSuffix != null : !this$piisIntegratedOauthSuffix.equals(other$piisIntegratedOauthSuffix)) {
            return false;
        }
        String this$aisPreStepOauthSuffix = this.getAisPreStepOauthSuffix();
        String other$aisPreStepOauthSuffix = other.getAisPreStepOauthSuffix();
        if (this$aisPreStepOauthSuffix == null ? other$aisPreStepOauthSuffix != null : !this$aisPreStepOauthSuffix.equals(other$aisPreStepOauthSuffix)) {
            return false;
        }
        String this$pisPreStepOauthSuffix = this.getPisPreStepOauthSuffix();
        String other$pisPreStepOauthSuffix = other.getPisPreStepOauthSuffix();
        return !(this$pisPreStepOauthSuffix == null ? other$pisPreStepOauthSuffix != null : !this$pisPreStepOauthSuffix.equals(other$pisPreStepOauthSuffix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aisIntegratedOauthSuffix = this.getAisIntegratedOauthSuffix();
        result = result * 59 + ($aisIntegratedOauthSuffix == null ? 43 : $aisIntegratedOauthSuffix.hashCode());
        String $pisIntegratedOauthSuffix = this.getPisIntegratedOauthSuffix();
        result = result * 59 + ($pisIntegratedOauthSuffix == null ? 43 : $pisIntegratedOauthSuffix.hashCode());
        String $piisIntegratedOauthSuffix = this.getPiisIntegratedOauthSuffix();
        result = result * 59 + ($piisIntegratedOauthSuffix == null ? 43 : $piisIntegratedOauthSuffix.hashCode());
        String $aisPreStepOauthSuffix = this.getAisPreStepOauthSuffix();
        result = result * 59 + ($aisPreStepOauthSuffix == null ? 43 : $aisPreStepOauthSuffix.hashCode());
        String $pisPreStepOauthSuffix = this.getPisPreStepOauthSuffix();
        result = result * 59 + ($pisPreStepOauthSuffix == null ? 43 : $pisPreStepOauthSuffix.hashCode());
        return result;
    }

    public String toString() {
        return "OAuthConfiguration(aisIntegratedOauthSuffix=" + this.getAisIntegratedOauthSuffix() + ", pisIntegratedOauthSuffix=" + this.getPisIntegratedOauthSuffix() + ", piisIntegratedOauthSuffix=" + this.getPiisIntegratedOauthSuffix() + ", aisPreStepOauthSuffix=" + this.getAisPreStepOauthSuffix() + ", pisPreStepOauthSuffix=" + this.getPisPreStepOauthSuffix() + ")";
    }
}

