/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthDataHolder;
import de.adorsys.aspsp.xs2a.connector.oauth.TokenValidationService;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import de.adorsys.psd2.xs2a.web.request.RequestPathResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenAuthenticationFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String INSTANCE_ID = "instance-id";
    private static final String CONSENT_ENP_ENDING = "consents";
    private static final String FUNDS_CONF_ENP_ENDING = "funds-confirmations";
    private final TokenValidationService tokenValidationService;
    private final AspspProfileService aspspProfileService;
    private final TppErrorMessageWriter tppErrorMessageWriter;
    private final OauthDataHolder oauthDataHolder;
    private final RequestPathResolver requestPathResolver;

    public TokenAuthenticationFilter(TokenValidationService tokenValidationService, Xs2aEndpointChecker xs2aEndpointChecker, AspspProfileService aspspProfileService, TppErrorMessageWriter tppErrorMessageWriter, OauthDataHolder oauthDataHolder, RequestPathResolver requestPathResolver) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.tokenValidationService = tokenValidationService;
        this.aspspProfileService = aspspProfileService;
        this.tppErrorMessageWriter = tppErrorMessageWriter;
        this.oauthDataHolder = oauthDataHolder;
        this.requestPathResolver = requestPathResolver;
    }

    protected void doFilterInternalCustom(HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) throws IOException, ServletException {
        AspspSettings aspspSettings;
        ScaRedirectFlow scaRedirectFlow;
        String instanceId = request.getHeader(INSTANCE_ID);
        List scaApproaches = this.aspspProfileService.getScaApproaches(instanceId);
        if (!this.isOAuthRequest(scaApproaches, scaRedirectFlow = (aspspSettings = this.aspspProfileService.getAspspSettings(instanceId)).getCommon().getScaRedirectFlow())) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String bearerToken = this.getBearerToken(request);
        if (this.isInvalidOauthRequest(request, response, bearerToken, instanceId, aspspSettings)) {
            return;
        }
        this.oauthDataHolder.setToken(bearerToken);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isInvalidOauthRequest(HttpServletRequest request, @NotNull HttpServletResponse response, String bearerToken, String instanceId, AspspSettings aspspSettings) throws IOException {
        String requestPath;
        ScaRedirectFlow scaRedirectFlow = aspspSettings.getCommon().getScaRedirectFlow();
        boolean tokenRequired = this.isTokenRequired(scaRedirectFlow, requestPath = this.requestPathResolver.resolveRequestPath(request), instanceId);
        if (tokenRequired && StringUtils.isBlank((CharSequence)bearerToken)) {
            log.info("Token authentication error: token is absent in redirect OAuth pre-step.");
            String oauthConfigurationUrl = aspspSettings.getCommon().getOauthConfigurationUrl();
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.UNAUTHORIZED_NO_TOKEN, oauthConfigurationUrl));
            return true;
        }
        if (tokenRequired && this.isTokenInvalid(bearerToken)) {
            log.info("Token authentication error: token is invalid");
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.TOKEN_INVALID, new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isOAuthRequest(List<ScaApproach> scaApproaches, ScaRedirectFlow scaRedirectFlow) {
        return scaApproaches.contains(ScaApproach.REDIRECT) && EnumSet.of(ScaRedirectFlow.OAUTH_PRE_STEP, ScaRedirectFlow.OAUTH).contains(scaRedirectFlow);
    }

    private String getBearerToken(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Authorization")).filter(StringUtils::isNotBlank).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)BEARER_TOKEN_PREFIX)).map(t -> StringUtils.substringAfter((String)t, (String)BEARER_TOKEN_PREFIX)).orElse(null);
    }

    private boolean isTokenInvalid(String bearerToken) {
        return this.tokenValidationService.validate(bearerToken) == null;
    }

    private TppErrorMessage buildTppErrorMessage(MessageErrorCode messageErrorCode, Object ... params) {
        return new TppErrorMessage(MessageCategory.ERROR, messageErrorCode, params);
    }

    private boolean isTokenRequired(ScaRedirectFlow oauthType, String requestPath, String instanceId) {
        if (oauthType == ScaRedirectFlow.OAUTH_PRE_STEP) {
            return true;
        }
        String trimmedRequestPath = this.trimEndingSlash(requestPath);
        if (trimmedRequestPath.endsWith(CONSENT_ENP_ENDING) || trimmedRequestPath.endsWith(FUNDS_CONF_ENP_ENDING)) {
            return false;
        }
        Set supportedProducts = this.aspspProfileService.getAspspSettings(instanceId).getPis().getSupportedPaymentTypeAndProductMatrix().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return supportedProducts.stream().noneMatch(trimmedRequestPath::endsWith);
    }

    private String trimEndingSlash(String input) {
        String result = input;
        while (StringUtils.endsWith((CharSequence)result, (CharSequence)"/")) {
            result = StringUtils.removeEnd((String)result, (String)"/");
        }
        return result;
    }
}

