/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthDataHolder;
import de.adorsys.aspsp.xs2a.connector.oauth.OauthType;
import de.adorsys.aspsp.xs2a.connector.oauth.TokenValidationService;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.domain.MessageCategory;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.web.Xs2aEndpointChecker;
import de.adorsys.psd2.xs2a.web.error.TppErrorMessageWriter;
import de.adorsys.psd2.xs2a.web.filter.AbstractXs2aFilter;
import de.adorsys.psd2.xs2a.web.filter.TppErrorMessage;
import de.adorsys.psd2.xs2a.web.request.RequestPathResolver;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TokenAuthenticationFilter
extends AbstractXs2aFilter {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String CONSENT_ENP_ENDING = "consents";
    private static final String FUNDS_CONF_ENP_ENDING = "funds-confirmations";
    private static final String INSTANCE_ID = "instance-id";
    private final RequestPathResolver requestPathResolver;
    private final String oauthModeHeaderName;
    private final TokenValidationService tokenValidationService;
    private final AspspProfileService aspspProfileService;
    private final OauthDataHolder oauthDataHolder;
    private final TppErrorMessageWriter tppErrorMessageWriter;

    public TokenAuthenticationFilter(RequestPathResolver requestPathResolver, @Value(value="${oauth.header-name:X-OAUTH-PREFERRED}") String oauthModeHeaderName, Xs2aEndpointChecker xs2aEndpointChecker, TokenValidationService tokenValidationService, AspspProfileService aspspProfileService, OauthDataHolder oauthDataHolder, TppErrorMessageWriter tppErrorMessageWriter) {
        super(tppErrorMessageWriter, xs2aEndpointChecker);
        this.requestPathResolver = requestPathResolver;
        this.oauthModeHeaderName = oauthModeHeaderName;
        this.tokenValidationService = tokenValidationService;
        this.aspspProfileService = aspspProfileService;
        this.oauthDataHolder = oauthDataHolder;
        this.tppErrorMessageWriter = tppErrorMessageWriter;
    }

    protected void doFilterInternalCustom(HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) throws IOException, ServletException {
        String bearerToken;
        String oauthHeader = request.getHeader(this.oauthModeHeaderName);
        boolean isOauthMode = StringUtils.isNotBlank((CharSequence)oauthHeader);
        if (!isOauthMode) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Optional<OauthType> oauthTypeOptional = OauthType.getByValue(oauthHeader);
        if (oauthTypeOptional.isEmpty()) {
            log.info("Token authentication error: unknown OAuth type {}", (Object)oauthHeader);
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.FORMAT_ERROR, new Object[0]));
            return;
        }
        OauthType oauthType = oauthTypeOptional.get();
        if (this.isInvalidOauthRequest(request, response, oauthType, bearerToken = this.resolveBearerToken(request))) {
            return;
        }
        this.oauthDataHolder.setOauthTypeAndToken(oauthType, bearerToken);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isInvalidOauthRequest(HttpServletRequest request, @NotNull HttpServletResponse response, OauthType oauthType, String bearerToken) throws IOException {
        String instanceId = request.getHeader(INSTANCE_ID);
        if (!this.aspspProfileService.getScaApproaches(instanceId).contains(ScaApproach.OAUTH)) {
            log.info("Token authentication error: OAUTH SCA approach is not supported in the profile");
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.FORMAT_ERROR, new Object[0]));
            return true;
        }
        if (oauthType == OauthType.PRE_STEP && StringUtils.isBlank((CharSequence)bearerToken)) {
            log.info("Token authentication error: token is absent in pre-step OAuth");
            String oauthConfigurationUrl = this.aspspProfileService.getAspspSettings(instanceId).getCommon().getOauthConfigurationUrl();
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.UNAUTHORIZED_NO_TOKEN, oauthConfigurationUrl));
            return true;
        }
        String requestPath = this.requestPathResolver.resolveRequestPath(request);
        boolean tokenRequired = this.isTokenRequired(oauthType, requestPath, instanceId);
        if (tokenRequired && this.isTokenInvalid(bearerToken)) {
            log.info("Token authentication error: token is invalid");
            this.tppErrorMessageWriter.writeError(response, this.buildTppErrorMessage(MessageErrorCode.TOKEN_INVALID, new Object[0]));
            return true;
        }
        return false;
    }

    private boolean isTokenRequired(OauthType oauthType, String requestPath, String instanceId) {
        if (oauthType == OauthType.PRE_STEP) {
            return true;
        }
        String trimmedRequestPath = this.trimEndingSlash(requestPath);
        if (trimmedRequestPath.endsWith(CONSENT_ENP_ENDING) || trimmedRequestPath.endsWith(FUNDS_CONF_ENP_ENDING)) {
            return false;
        }
        Set supportedProducts = this.aspspProfileService.getAspspSettings(instanceId).getPis().getSupportedPaymentTypeAndProductMatrix().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        return supportedProducts.stream().noneMatch(trimmedRequestPath::endsWith);
    }

    private boolean isTokenInvalid(String bearerToken) {
        BearerTokenTO token = this.tokenValidationService.validate(bearerToken);
        return token == null;
    }

    private String resolveBearerToken(HttpServletRequest request) {
        return Optional.ofNullable(request.getHeader("Authorization")).filter(StringUtils::isNotBlank).filter(t -> StringUtils.startsWithIgnoreCase((CharSequence)t, (CharSequence)BEARER_TOKEN_PREFIX)).map(t -> StringUtils.substringAfter((String)t, (String)BEARER_TOKEN_PREFIX)).orElse(null);
    }

    private String trimEndingSlash(String input) {
        String result = input;
        while (StringUtils.endsWith((CharSequence)result, (CharSequence)"/")) {
            result = StringUtils.removeEnd((String)result, (String)"/");
        }
        return result;
    }

    private TppErrorMessage buildTppErrorMessage(MessageErrorCode messageErrorCode, Object ... params) {
        return new TppErrorMessage(MessageCategory.ERROR, messageErrorCode, params);
    }
}

