/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TokenValidationService {
    private static final Logger log = LoggerFactory.getLogger(TokenValidationService.class);
    private final AuthRequestInterceptor authInterceptor;
    private final UserMgmtRestClient ledgersUserMgmt;

    public BearerTokenTO validate(String bearerToken) {
        try {
            this.authInterceptor.setAccessToken(bearerToken);
            BearerTokenTO bearerTokenTO = (BearerTokenTO)this.ledgersUserMgmt.validate(bearerToken).getBody();
            return bearerTokenTO;
        }
        catch (FeignException e) {
            log.error("Token validation is failed");
        }
        finally {
            this.authInterceptor.setAccessToken(null);
        }
        return null;
    }

    public TokenValidationService(AuthRequestInterceptor authInterceptor, UserMgmtRestClient ledgersUserMgmt) {
        this.authInterceptor = authInterceptor;
        this.ledgersUserMgmt = ledgersUserMgmt;
    }
}

