/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.aspsp.xs2a.connector.oauth.OauthDataHolder;
import de.adorsys.aspsp.xs2a.connector.oauth.OauthType;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.mapper.ServiceType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class OauthProfileServiceWrapper
implements AspspProfileService {
    private final AspspProfileService aspspProfileService;
    private final OauthDataHolder oauthDataHolder;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final String aisIntegratedOauthSuffix;
    private final String pisIntegratedOauthSuffix;
    private final String aisPreStepOauthSuffix;
    private final String pisPreStepOauthSuffix;

    public OauthProfileServiceWrapper(AspspProfileService aspspProfileService, OauthDataHolder oauthDataHolder, ServiceTypeDiscoveryService serviceTypeDiscoveryService, @Value(value="${oauth.integrated.ais.suffix:?consentId={encrypted-consent-id}&redirectId={redirect-id}}") String aisIntegratedOauthSuffix, @Value(value="${oauth.integrated.pis.suffix:?paymentId={encrypted-payment-id}&redirectId={redirect-id}}") String pisIntegratedOauthSuffix, @Value(value="${oauth.pre-step.ais.suffix:&token=}") String aisPreStepOauthSuffix, @Value(value="${oauth.pre-step.pis.suffix:&token=}") String pisPreStepOauthSuffix) {
        this.aspspProfileService = aspspProfileService;
        this.oauthDataHolder = oauthDataHolder;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.aisIntegratedOauthSuffix = aisIntegratedOauthSuffix;
        this.pisIntegratedOauthSuffix = pisIntegratedOauthSuffix;
        this.aisPreStepOauthSuffix = aisPreStepOauthSuffix;
        this.pisPreStepOauthSuffix = pisPreStepOauthSuffix;
    }

    public AspspSettings getAspspSettings() {
        AspspSettings profileSettings = this.aspspProfileService.getAspspSettings();
        OauthType oauthType = this.oauthDataHolder.getOauthType();
        CommonAspspProfileSetting existingCommonSetting = profileSettings.getCommon();
        if (oauthType == OauthType.INTEGRATED) {
            String customOauthLink = existingCommonSetting.getOauthConfigurationUrl() + this.buildOauthLinkSuffix();
            CommonAspspProfileSetting customCommonSettings = this.buildCustomCommonSetting(existingCommonSetting, ScaRedirectFlow.OAUTH, customOauthLink);
            return new AspspSettings(profileSettings.getAis(), profileSettings.getPis(), profileSettings.getPiis(), customCommonSettings);
        }
        if (oauthType == OauthType.PRE_STEP) {
            CommonAspspProfileSetting customCommonSetting = this.buildCustomCommonSetting(existingCommonSetting, ScaRedirectFlow.OAUTH_PRE_STEP, existingCommonSetting.getOauthConfigurationUrl());
            String aisSuffixWithToken = this.aisPreStepOauthSuffix + StringUtils.defaultString((String)this.oauthDataHolder.getToken());
            AisAspspProfileSetting customAisSetting = this.buildCustomAisAspspProfileSetting(profileSettings.getAis(), aisSuffixWithToken);
            String pisSuffixWithToken = this.pisPreStepOauthSuffix + StringUtils.defaultString((String)this.oauthDataHolder.getToken());
            PisAspspProfileSetting customPisSetting = this.buildCustomPisAspspProfileSetting(profileSettings.getPis(), pisSuffixWithToken);
            return new AspspSettings(customAisSetting, customPisSetting, profileSettings.getPiis(), customCommonSetting);
        }
        return profileSettings;
    }

    public List<ScaApproach> getScaApproaches() {
        return this.aspspProfileService.getScaApproaches();
    }

    private String buildOauthLinkSuffix() {
        ServiceType serviceType = this.serviceTypeDiscoveryService.getServiceType();
        if (serviceType == ServiceType.AIS) {
            return this.aisIntegratedOauthSuffix;
        }
        if (serviceType == ServiceType.PIS) {
            return this.pisIntegratedOauthSuffix;
        }
        return "";
    }

    private CommonAspspProfileSetting buildCustomCommonSetting(CommonAspspProfileSetting existingSetting, ScaRedirectFlow scaRedirectFlow, String oauthConfigurationUrl) {
        return new CommonAspspProfileSetting(scaRedirectFlow, oauthConfigurationUrl, existingSetting.getStartAuthorisationMode(), existingSetting.isTppSignatureRequired(), existingSetting.isPsuInInitialRequestMandated(), existingSetting.getRedirectUrlExpirationTimeMs(), existingSetting.getAuthorisationExpirationTimeMs(), existingSetting.isForceXs2aBaseLinksUrl(), existingSetting.getXs2aBaseLinksUrl(), existingSetting.getSupportedAccountReferenceFields(), existingSetting.getMulticurrencyAccountLevelSupported(), existingSetting.isAisPisSessionsSupported(), existingSetting.isSigningBasketSupported(), existingSetting.isCheckTppRolesFromCertificateSupported(), existingSetting.getAspspNotificationsSupported(), existingSetting.isAuthorisationConfirmationRequestMandated(), existingSetting.isAuthorisationConfirmationCheckByXs2a());
    }

    private AisAspspProfileSetting buildCustomAisAspspProfileSetting(AisAspspProfileSetting existingSetting, String redirectUrlSuffix) {
        String customRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getAisRedirectUrlToAspsp() + redirectUrlSuffix;
        return new AisAspspProfileSetting(existingSetting.getConsentTypes(), new AisRedirectLinkSetting(customRedirectUrl), existingSetting.getTransactionParameters(), existingSetting.getDeltaReportSettings(), existingSetting.getScaRequirementsForOneTimeConsents());
    }

    private PisAspspProfileSetting buildCustomPisAspspProfileSetting(PisAspspProfileSetting existingSetting, String redirectUrlSuffix) {
        String customInitiationRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getPisRedirectUrlToAspsp() + redirectUrlSuffix;
        String customCancellationRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getPisPaymentCancellationRedirectUrlToAspsp() + redirectUrlSuffix;
        PisRedirectLinkSetting redirectLinkToOnlineBanking = existingSetting.getRedirectLinkToOnlineBanking();
        PisRedirectLinkSetting customRedirectLinkSetting = new PisRedirectLinkSetting(customInitiationRedirectUrl, customCancellationRedirectUrl, redirectLinkToOnlineBanking.getPaymentCancellationRedirectUrlExpirationTimeMs());
        return new PisAspspProfileSetting(existingSetting.getSupportedPaymentTypeAndProductMatrix(), existingSetting.getMaxTransactionValidityDays(), existingSetting.getNotConfirmedPaymentExpirationTimeMs(), existingSetting.isPaymentCancellationAuthorisationMandated(), customRedirectLinkSetting, existingSetting.getCountryValidationSupported(), existingSetting.getSupportedTransactionStatusFormats());
    }
}

