/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.oauth;

import de.adorsys.aspsp.xs2a.connector.oauth.OAuthConfiguration;
import de.adorsys.aspsp.xs2a.connector.oauth.OauthDataHolder;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.discovery.ServiceTypeDiscoveryService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class OauthProfileServiceWrapper
implements AspspProfileService {
    private final AspspProfileService aspspProfileService;
    private final OauthDataHolder oauthDataHolder;
    private final ServiceTypeDiscoveryService serviceTypeDiscoveryService;
    private final RequestProviderService requestProviderService;
    private final OAuthConfiguration oAuthConfiguration;

    public OauthProfileServiceWrapper(AspspProfileService aspspProfileService, OauthDataHolder oauthDataHolder, ServiceTypeDiscoveryService serviceTypeDiscoveryService, RequestProviderService requestProviderService, OAuthConfiguration oAuthConfiguration) {
        this.aspspProfileService = aspspProfileService;
        this.oauthDataHolder = oauthDataHolder;
        this.serviceTypeDiscoveryService = serviceTypeDiscoveryService;
        this.requestProviderService = requestProviderService;
        this.oAuthConfiguration = oAuthConfiguration;
    }

    public AspspSettings getAspspSettings(String instanceId) {
        AspspSettings profileSettings = this.aspspProfileService.getAspspSettings(instanceId);
        ScaRedirectFlow scaRedirectFlow = profileSettings.getCommon().getScaRedirectFlow();
        CommonAspspProfileSetting existingCommonSetting = profileSettings.getCommon();
        if (scaRedirectFlow == ScaRedirectFlow.OAUTH) {
            String customOauthLink = existingCommonSetting.getOauthConfigurationUrl() + this.oAuthConfiguration.getIntegratedOauthSuffix(this.serviceTypeDiscoveryService.getServiceType());
            CommonAspspProfileSetting customCommonSettings = this.buildCustomCommonSetting(existingCommonSetting, ScaRedirectFlow.OAUTH, customOauthLink);
            return new AspspSettings(profileSettings.getAis(), profileSettings.getPis(), profileSettings.getPiis(), profileSettings.getSb(), customCommonSettings);
        }
        if (scaRedirectFlow == ScaRedirectFlow.OAUTH_PRE_STEP) {
            CommonAspspProfileSetting customCommonSetting = this.buildCustomCommonSetting(existingCommonSetting, ScaRedirectFlow.OAUTH_PRE_STEP, existingCommonSetting.getOauthConfigurationUrl());
            String aisSuffixWithToken = this.oAuthConfiguration.getAisPreStepOauthSuffix() + StringUtils.defaultString((String)this.oauthDataHolder.getToken());
            AisAspspProfileSetting customAisSetting = this.buildCustomAisAspspProfileSetting(profileSettings.getAis(), aisSuffixWithToken);
            String pisSuffixWithToken = this.oAuthConfiguration.getPisPreStepOauthSuffix() + StringUtils.defaultString((String)this.oauthDataHolder.getToken());
            PisAspspProfileSetting customPisSetting = this.buildCustomPisAspspProfileSetting(profileSettings.getPis(), pisSuffixWithToken);
            return new AspspSettings(customAisSetting, customPisSetting, profileSettings.getPiis(), profileSettings.getSb(), customCommonSetting);
        }
        return profileSettings;
    }

    public List<ScaApproach> getScaApproaches(String instanceId) {
        return this.aspspProfileService.getScaApproaches(instanceId);
    }

    public List<ScaApproach> getScaApproaches() {
        return this.aspspProfileService.getScaApproaches(this.requestProviderService.getInstanceId());
    }

    public ScaRedirectFlow getScaRedirectFlow() {
        return this.aspspProfileService.getAspspSettings(this.requestProviderService.getInstanceId()).getCommon().getScaRedirectFlow();
    }

    public boolean isMultitenancyEnabled() {
        return this.aspspProfileService.isMultitenancyEnabled();
    }

    private CommonAspspProfileSetting buildCustomCommonSetting(CommonAspspProfileSetting existingSetting, ScaRedirectFlow scaRedirectFlow, String oauthConfigurationUrl) {
        return new CommonAspspProfileSetting(scaRedirectFlow, oauthConfigurationUrl, existingSetting.getStartAuthorisationMode(), existingSetting.isTppSignatureRequired(), existingSetting.isPsuInInitialRequestMandated(), existingSetting.getRedirectUrlExpirationTimeMs(), existingSetting.getAuthorisationExpirationTimeMs(), existingSetting.isForceXs2aBaseLinksUrl(), existingSetting.getXs2aBaseLinksUrl(), existingSetting.getSupportedAccountReferenceFields(), existingSetting.getMulticurrencyAccountLevelSupported(), existingSetting.isAisPisSessionsSupported(), existingSetting.isCheckTppRolesFromCertificateSupported(), existingSetting.getAspspNotificationsSupported(), existingSetting.isAuthorisationConfirmationRequestMandated(), existingSetting.isAuthorisationConfirmationCheckByXs2a(), existingSetting.isCheckUriComplianceToDomainSupported(), existingSetting.getTppUriComplianceResponse(), existingSetting.isPsuInInitialRequestIgnored());
    }

    private AisAspspProfileSetting buildCustomAisAspspProfileSetting(AisAspspProfileSetting existingSetting, String redirectUrlSuffix) {
        String customRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getAisRedirectUrlToAspsp() + redirectUrlSuffix;
        return new AisAspspProfileSetting(existingSetting.getConsentTypes(), new AisRedirectLinkSetting(customRedirectUrl), existingSetting.getTransactionParameters(), existingSetting.getDeltaReportSettings(), existingSetting.getScaRequirementsForOneTimeConsents());
    }

    private PisAspspProfileSetting buildCustomPisAspspProfileSetting(PisAspspProfileSetting existingSetting, String redirectUrlSuffix) {
        String customInitiationRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getPisRedirectUrlToAspsp() + redirectUrlSuffix;
        String customCancellationRedirectUrl = existingSetting.getRedirectLinkToOnlineBanking().getPisPaymentCancellationRedirectUrlToAspsp() + redirectUrlSuffix;
        PisRedirectLinkSetting redirectLinkToOnlineBanking = existingSetting.getRedirectLinkToOnlineBanking();
        PisRedirectLinkSetting customRedirectLinkSetting = new PisRedirectLinkSetting(customInitiationRedirectUrl, customCancellationRedirectUrl, redirectLinkToOnlineBanking.getPaymentCancellationRedirectUrlExpirationTimeMs());
        return new PisAspspProfileSetting(existingSetting.getSupportedPaymentTypeAndProductMatrix(), existingSetting.getMaxTransactionValidityDays(), existingSetting.getNotConfirmedPaymentExpirationTimeMs(), existingSetting.isPaymentCancellationAuthorisationMandated(), customRedirectLinkSetting, existingSetting.getCountryValidationSupported(), existingSetting.getSupportedTransactionStatusFormats());
    }
}

