/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.util.tan.encriptor;

import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EncryptorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EncryptorConfiguration.class);
    @Value(value="${ledgers.application.security.encryptorAlgorithm}")
    private String encryptorAlgorithm;
    @Value(value="${ledgers.application.security.masterPassword}")
    private String masterPassword;

    @Bean
    public StandardPBEStringEncryptor stringEncryptor() {
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        log.info("Algorithm: {}", (Object)this.encryptorAlgorithm);
        log.info("masterPass: {}", (Object)this.masterPassword);
        encryptor.setPassword(this.masterPassword);
        encryptor.setAlgorithm(this.encryptorAlgorithm);
        return encryptor;
    }
}

