/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.util.hash;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.util.Base16;
import de.adorsys.ledgers.util.hash.HashGenerationException;
import de.adorsys.ledgers.util.hash.HashGenerator;
import de.adorsys.ledgers.util.hash.HashItem;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashGeneratorImpl
implements HashGenerator {
    private static final Logger logger = LoggerFactory.getLogger(HashGeneratorImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String ERROR_MSG = "Can't generate the hash";

    @Override
    public <T> String hash(HashItem<T> hashItem) throws HashGenerationException {
        byte[] valueAsBytes;
        MessageDigest digest;
        try {
            String alg = StringUtils.isBlank((CharSequence)hashItem.getAlg()) ? "SHA-256" : hashItem.getAlg();
            digest = MessageDigest.getInstance(alg);
            valueAsBytes = objectMapper.writeValueAsBytes(hashItem.getItem());
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            logger.error(ERROR_MSG, e);
            throw new HashGenerationException(ERROR_MSG, e);
        }
        return Base16.encode(digest.digest(valueAsBytes));
    }
}

