/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class CloneUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> T cloneObject(Object in, Class<T> type) {
        if (in == null) {
            return null;
        }
        try {
            byte[] bytes = objectMapper.writeValueAsBytes(in);
            return (T)objectMapper.readValue(bytes, type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> List<T> cloneList(List<?> in, Class<T> type) {
        return in.stream().map(t -> CloneUtils.cloneObject(t, type)).collect(Collectors.toList());
    }

    static {
        objectMapper.findAndRegisterModules();
    }
}

