/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.api.domain;

import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UserBO {
    private String id;
    private String login;
    private String email;
    private String pin;
    private List<ScaUserDataBO> scaUserData = new ArrayList<ScaUserDataBO>();
    private List<AccountAccessBO> accountAccesses = new ArrayList<AccountAccessBO>();
    private Collection<UserRoleBO> userRoles = new ArrayList<UserRoleBO>();
    private String branch;
    private boolean blocked;
    private boolean systemBlocked;

    public UserBO(@NotNull String login, @NotNull String email, @NotNull String pin) {
        this.login = login;
        this.email = email;
        this.pin = pin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserBO)) {
            return false;
        }
        UserBO userBO = (UserBO)o;
        return Objects.equals(this.getId(), userBO.getId()) && Objects.equals(this.getLogin(), userBO.getLogin()) && Objects.equals(this.getEmail(), userBO.getEmail()) && Objects.equals(this.getPin(), userBO.getPin()) && Objects.equals(this.getScaUserData(), userBO.getScaUserData()) && Objects.equals(this.getAccountAccesses(), userBO.getAccountAccesses()) && Objects.equals(this.getUserRoles(), userBO.getUserRoles()) && Objects.equals(this.getBranch(), userBO.getBranch()) && Objects.equals(this.isBlocked(), userBO.isBlocked()) && Objects.equals(this.isSystemBlocked(), userBO.isSystemBlocked());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getLogin(), this.getEmail(), this.getPin(), this.getScaUserData(), this.getAccountAccesses(), this.getUserRoles(), this.getBranch(), this.isBlocked(), this.isSystemBlocked());
    }

    public String toString() {
        return "UserBO{id='" + this.id + '\'' + ", login='" + this.login + '\'' + ", email='" + this.email + '\'' + ", pin='" + this.pin + '\'' + ", scaUserData=" + this.scaUserData + ", accountAccesses=" + this.accountAccesses + ", userRoles=" + this.userRoles + ", branch='" + this.branch + '\'' + ", blocked='" + this.blocked + '\'' + ", systemBlocked='" + this.systemBlocked + '\'' + '}';
    }

    public boolean isEnabled() {
        return !this.isBlocked() && !this.isSystemBlocked();
    }

    public boolean hasAccessToAccount(String iban) {
        return this.accountAccesses.stream().anyMatch(a -> StringUtils.equalsIgnoreCase((CharSequence)a.getIban(), (CharSequence)iban));
    }

    public boolean hasAccessToAccount(String iban, Currency currency) {
        return this.accountAccesses.stream().anyMatch(a -> StringUtils.equalsIgnoreCase((CharSequence)a.getIban(), (CharSequence)iban) && a.getCurrency().equals(currency));
    }

    public String getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPin() {
        return this.pin;
    }

    public List<ScaUserDataBO> getScaUserData() {
        return this.scaUserData;
    }

    public List<AccountAccessBO> getAccountAccesses() {
        return this.accountAccesses;
    }

    public Collection<UserRoleBO> getUserRoles() {
        return this.userRoles;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSystemBlocked() {
        return this.systemBlocked;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setScaUserData(List<ScaUserDataBO> scaUserData) {
        this.scaUserData = scaUserData;
    }

    public void setAccountAccesses(List<AccountAccessBO> accountAccesses) {
        this.accountAccesses = accountAccesses;
    }

    public void setUserRoles(Collection<UserRoleBO> userRoles) {
        this.userRoles = userRoles;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setSystemBlocked(boolean systemBlocked) {
        this.systemBlocked = systemBlocked;
    }

    public UserBO() {
    }
}

