/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.api.domain;

import de.adorsys.ledgers.um.api.domain.EmailVerificationStatusBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDateTime;

public class EmailVerificationBO {
    private Long id;
    private String token;
    private EmailVerificationStatusBO status;
    private LocalDateTime expiredDateTime;
    private LocalDateTime issuedDateTime;
    private LocalDateTime confirmedDateTime;
    private ScaUserDataBO scaUserData;

    public void createToken() {
        LocalDateTime now = LocalDateTime.now();
        this.setToken(Ids.id());
        this.setExpiredDateTime(now.plusWeeks(1L));
        this.setStatus(EmailVerificationStatusBO.PENDING);
        this.setIssuedDateTime(now);
    }

    public void updateToken() {
        LocalDateTime now = LocalDateTime.now();
        this.setExpiredDateTime(now.plusWeeks(1L));
        this.setIssuedDateTime(now);
    }

    public boolean isExpired() {
        return this.getExpiredDateTime().isBefore(LocalDateTime.now());
    }

    public String formatMessage(String message, String basePath, String endpoint, String token, LocalDateTime date) {
        return String.format(message, basePath + endpoint + "?verificationToken=" + token, date.getMonth().toString() + " " + date.getDayOfMonth() + ", " + date.getYear() + " " + date.getHour() + ":" + date.getMinute());
    }

    public Long getId() {
        return this.id;
    }

    public String getToken() {
        return this.token;
    }

    public EmailVerificationStatusBO getStatus() {
        return this.status;
    }

    public LocalDateTime getExpiredDateTime() {
        return this.expiredDateTime;
    }

    public LocalDateTime getIssuedDateTime() {
        return this.issuedDateTime;
    }

    public LocalDateTime getConfirmedDateTime() {
        return this.confirmedDateTime;
    }

    public ScaUserDataBO getScaUserData() {
        return this.scaUserData;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setStatus(EmailVerificationStatusBO status) {
        this.status = status;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }

    public void setIssuedDateTime(LocalDateTime issuedDateTime) {
        this.issuedDateTime = issuedDateTime;
    }

    public void setConfirmedDateTime(LocalDateTime confirmedDateTime) {
        this.confirmedDateTime = confirmedDateTime;
    }

    public void setScaUserData(ScaUserDataBO scaUserData) {
        this.scaUserData = scaUserData;
    }
}

