/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.rest.controller;

import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.exception.UserAlreadyExistsException;
import de.adorsys.ledgers.um.api.exception.UserNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.um.rest.exception.NotFoundRestException;
import java.net.URI;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/users/"})
public class UserResource {
    static final String USERS = "/users/";
    private static final String SCA_DATA = "sca-data";
    private final UserService userService;

    public UserResource(UserService userService) {
        this.userService = userService;
    }

    @PostMapping
    ResponseEntity<Void> createUser(@RequestBody UserBO user) throws UserAlreadyExistsException {
        UserBO userBO = this.userService.create(user);
        URI uri = UriComponentsBuilder.fromUriString((String)(USERS + userBO.getLogin())).build().toUri();
        return ResponseEntity.created((URI)uri).build();
    }

    @GetMapping(value={"{id}"})
    ResponseEntity<UserBO> getUserById(@PathVariable(value="id") String id) {
        try {
            return ResponseEntity.ok((Object)this.userService.findById(id));
        }
        catch (UserNotFoundException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @GetMapping
    ResponseEntity<UserBO> getUserByLogin(@RequestParam(value="login") String login) {
        try {
            return ResponseEntity.ok((Object)this.userService.findByLogin(login));
        }
        catch (UserNotFoundException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @PutMapping(value={"{id}/sca-data"})
    ResponseEntity<Void> updateUserScaData(@PathVariable String id, @RequestBody List<ScaUserDataBO> data) {
        try {
            UserBO userBO = this.userService.findById(id);
            UserBO user = this.userService.updateScaData(data, userBO.getLogin());
            URI uri = UriComponentsBuilder.fromUriString((String)(USERS + user.getId())).build().toUri();
            return ResponseEntity.created((URI)uri).build();
        }
        catch (UserNotFoundException e) {
            throw new NotFoundRestException(e.getMessage());
        }
    }

    @GetMapping(value={"all"})
    ResponseEntity<List<UserBO>> getAllUsers() {
        return ResponseEntity.ok((Object)this.userService.getAll());
    }
}

