/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.domain;

import java.time.OffsetDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;

@Entity(name="oauth_code")
public class OauthCodeEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="oauth_code_generator")
    @SequenceGenerator(name="oauth_code_generator", sequenceName="oauth_code_id_seq", allocationSize=1)
    private Long id;
    @Column(name="code", nullable=false)
    private String code;
    @Column(name="user_id", nullable=false)
    private String userId;
    @Column(name="expiry_time", nullable=false)
    private OffsetDateTime expiryTime;
    @Column(name="is_used", nullable=false)
    private boolean used;
    @Lob
    @Column(name="token", nullable=false)
    private String token;
    @Column(name="final_stage")
    private boolean finalStage;

    public OauthCodeEntity(String userId, String code, OffsetDateTime expiryTime, String token, boolean finalStage) {
        this.userId = userId;
        this.code = code;
        this.expiryTime = expiryTime;
        this.token = token;
        this.finalStage = finalStage;
    }

    public boolean isExpired() {
        return this.expiryTime.isBefore(OffsetDateTime.now());
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setFinalStage(boolean finalStage) {
        this.finalStage = finalStage;
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getUserId() {
        return this.userId;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public boolean isUsed() {
        return this.used;
    }

    public String getToken() {
        return this.token;
    }

    public boolean isFinalStage() {
        return this.finalStage;
    }

    public OauthCodeEntity() {
    }
}

