/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.domain;

import de.adorsys.ledgers.um.db.domain.AccountAccess;
import de.adorsys.ledgers.um.db.domain.ScaUserDataEntity;
import de.adorsys.ledgers.um.db.domain.UserRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="users", uniqueConstraints={@UniqueConstraint(columnNames={"login"}, name="user_login_unique"), @UniqueConstraint(columnNames={"email"}, name="user_email_unique")})
public class UserEntity {
    public static final String USER_LOGIN_UNIQUE = "user_login_unique";
    public static final String USER_EMAIL_UNIQUE = "user_email_unique";
    @Id
    @Column(name="user_id")
    private String id;
    @Column(nullable=false)
    private String login;
    @Column(nullable=false)
    private String email;
    @Column(nullable=false)
    private String pin;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @JoinColumn(name="user_id")
    private List<ScaUserDataEntity> scaUserData = new ArrayList<ScaUserDataEntity>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @JoinColumn(name="user_id")
    private List<AccountAccess> accountAccesses = new ArrayList<AccountAccess>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="users_roles", joinColumns={@JoinColumn(name="user_id")})
    @Column(name="role")
    @Enumerated(value=EnumType.STRING)
    private Collection<UserRole> userRoles = new ArrayList<UserRole>();
    private String branch;
    @Column(name="block")
    private boolean blocked;
    @Column(name="system_block")
    private boolean systemBlocked;

    public boolean isEnabled() {
        return !this.isBlocked() && !this.isSystemBlocked();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserEntity)) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getLogin(), that.getLogin()) && Objects.equals(this.getEmail(), that.getEmail()) && Objects.equals(this.getPin(), that.getPin()) && Objects.equals(this.getScaUserData(), that.getScaUserData()) && Objects.equals(this.getAccountAccesses(), that.getAccountAccesses()) && Objects.equals(this.getUserRoles(), that.getUserRoles()) && Objects.equals(this.getBranch(), that.getBranch()) && Objects.equals(this.isBlocked(), that.isBlocked()) && Objects.equals(this.isSystemBlocked(), that.isSystemBlocked());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getLogin(), this.getEmail(), this.getPin(), this.getScaUserData(), this.getAccountAccesses(), this.getUserRoles(), this.getBranch(), this.isBlocked(), this.isSystemBlocked());
    }

    public String getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPin() {
        return this.pin;
    }

    public List<ScaUserDataEntity> getScaUserData() {
        return this.scaUserData;
    }

    public List<AccountAccess> getAccountAccesses() {
        return this.accountAccesses;
    }

    public Collection<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public String getBranch() {
        return this.branch;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isSystemBlocked() {
        return this.systemBlocked;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setScaUserData(List<ScaUserDataEntity> scaUserData) {
        this.scaUserData = scaUserData;
    }

    public void setAccountAccesses(List<AccountAccess> accountAccesses) {
        this.accountAccesses = accountAccesses;
    }

    public void setUserRoles(Collection<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setSystemBlocked(boolean systemBlocked) {
        this.systemBlocked = systemBlocked;
    }
}

