/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.repository;

import de.adorsys.ledgers.um.db.domain.AccessType;
import de.adorsys.ledgers.um.db.domain.UserEntity;
import de.adorsys.ledgers.um.db.domain.UserRole;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;

public interface UserRepository
extends PagingAndSortingRepository<UserEntity, String> {
    public Optional<UserEntity> findFirstByLogin(String var1);

    public Optional<UserEntity> findByEmailOrLogin(String var1, String var2);

    @Query(value="update UserEntity u set u.systemBlocked=?2 where u.branch=?1")
    public void updateSystemBlockedStatus(String var1, boolean var2);

    @Query(value="update UserEntity u set u.blocked=?2 where u.branch=?1")
    public void updateBlockedStatus(String var1, boolean var2);

    @Query(value="select distinct u.id from UserEntity u where u.branch like ?1% and u.branch like  %?2% and u.login like %?3% and ?4 member of u.userRoles and u.systemBlocked=false ")
    public List<String> findBranchIdsByMultipleParameters(String var1, String var2, String var3, UserRole var4);

    public Page<UserEntity> findByBranchInAndLoginContainingAndUserRolesInAndBlockedInAndSystemBlockedFalse(Collection<String> var1, String var2, Collection<UserRole> var3, Collection<Boolean> var4, Pageable var5);

    public int countByBranch(String var1);

    public Optional<UserEntity> findByLoginAndEmail(String var1, String var2);

    @Query(value="select distinct u from UserEntity u join u.accountAccesses a where a.iban = ?1")
    public List<UserEntity> findUsersByIban(String var1);

    @Query(value="select distinct u from UserEntity u join u.accountAccesses a where a.iban = ?1 and a.accessType = ?2")
    public List<UserEntity> findOwnersByIban(String var1, AccessType var2);

    @Query(value="select distinct u from UserEntity u join u.accountAccesses a where a.accountId = ?1 and a.accessType = ?2")
    public List<UserEntity> findOwnersByAccountId(String var1, AccessType var2);
}

