/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.domain;

import de.adorsys.ledgers.um.db.domain.AccessType;
import de.adorsys.ledgers.util.Ids;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="account_accesses")
public class AccountAccess {
    @Id
    @Column(name="account_access_id")
    private String id;
    @Column(nullable=false)
    @NotNull
    private String iban;
    @Column(nullable=false)
    @NotNull
    private String currency;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private AccessType accessType = AccessType.OWNER;
    @Column(nullable=false)
    private int scaWeight;
    @Column(nullable=false)
    private String accountId;

    @PrePersist
    public void prePersist() {
        if (this.id == null) {
            this.id = Ids.id();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getIban() {
        return this.iban;
    }

    public String getCurrency() {
        return this.currency;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public int getScaWeight() {
        return this.scaWeight;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setScaWeight(int scaWeight) {
        this.scaWeight = scaWeight;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountAccess)) {
            return false;
        }
        AccountAccess other = (AccountAccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        AccessType this$accessType = this.getAccessType();
        AccessType other$accessType = other.getAccessType();
        if (this$accessType == null ? other$accessType != null : !((Object)((Object)this$accessType)).equals((Object)other$accessType)) {
            return false;
        }
        if (this.getScaWeight() != other.getScaWeight()) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountAccess;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        AccessType $accessType = this.getAccessType();
        result = result * 59 + ($accessType == null ? 43 : ((Object)((Object)$accessType)).hashCode());
        result = result * 59 + this.getScaWeight();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    public String toString() {
        return "AccountAccess(id=" + this.getId() + ", iban=" + this.getIban() + ", currency=" + this.getCurrency() + ", accessType=" + (Object)((Object)this.getAccessType()) + ", scaWeight=" + this.getScaWeight() + ", accountId=" + this.getAccountId() + ")";
    }
}

