/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.domain;

import java.time.OffsetDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;

@Entity(name="reset_password")
public class ResetPasswordEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="reset_password_generator")
    @SequenceGenerator(name="reset_password_generator", sequenceName="reset_password_id_seq", allocationSize=1)
    private Long id;
    @Column(name="code", nullable=false)
    private String code;
    @Column(name="user_id", nullable=false)
    private String userId;
    @Column(name="expiry_time", nullable=false)
    private OffsetDateTime expiryTime;

    public ResetPasswordEntity(String userId, String code, OffsetDateTime expiryTime) {
        this.userId = userId;
        this.code = code;
        this.expiryTime = expiryTime;
    }

    public boolean isExpired() {
        return this.expiryTime.isBefore(OffsetDateTime.now());
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getUserId() {
        return this.userId;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public ResetPasswordEntity() {
    }
}

