/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.um.db.domain;

import de.adorsys.ledgers.um.db.domain.AccountAccess;
import de.adorsys.ledgers.um.db.domain.ScaUserDataEntity;
import de.adorsys.ledgers.um.db.domain.UserRole;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="users", uniqueConstraints={@UniqueConstraint(columnNames={"login"}, name="user_login_unique"), @UniqueConstraint(columnNames={"email"}, name="user_email_unique")})
public class UserEntity {
    public static final String USER_LOGIN_UNIQUE = "user_login_unique";
    public static final String USER_EMAIL_UNIQUE = "user_email_unique";
    @Id
    @Column(name="user_id")
    private String id;
    @Column(nullable=false)
    private String login;
    @Column(nullable=false)
    private String email;
    @Column(nullable=false)
    private String pin;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @JoinColumn(name="user_id")
    private List<ScaUserDataEntity> scaUserData = new ArrayList<ScaUserDataEntity>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    @JoinColumn(name="user_id")
    private List<AccountAccess> accountAccesses = new ArrayList<AccountAccess>();
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="users_roles", joinColumns={@JoinColumn(name="user_id")})
    @Column(name="role")
    @Enumerated(value=EnumType.STRING)
    private Collection<UserRole> userRoles = new ArrayList<UserRole>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public List<ScaUserDataEntity> getScaUserData() {
        return this.scaUserData;
    }

    public void setScaUserData(List<ScaUserDataEntity> scaUserData) {
        this.scaUserData = scaUserData;
    }

    public List<AccountAccess> getAccountAccesses() {
        return this.accountAccesses;
    }

    public void setAccountAccesses(List<AccountAccess> accountAccesses) {
        this.accountAccesses = accountAccesses;
    }

    public Collection<UserRole> getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(Collection<UserRole> userRoles) {
        this.userRoles = userRoles;
    }
}

