/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.sender;

import de.adorsys.ledgers.sca.domain.sca.message.PushScaMessage;
import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class PushOtpSender
implements SCASender<PushScaMessage> {
    private static final Logger log = LoggerFactory.getLogger(PushOtpSender.class);
    private static final String ERROR_REASON_2_MATCHERS = "Could not PUSH TAN for Sca, reason: %s %s";
    private final RestTemplate template;

    public boolean send(PushScaMessage message) {
        try {
            HttpEntity httpEntity = new HttpEntity((Object)message.getMessage());
            HttpMethod httpMethod = Optional.ofNullable(HttpMethod.resolve((String)message.getHttpMethod())).orElseThrow(() -> ScaModuleException.buildScaSenderException((String)("Could not resolve HttpMethod for PsuhOTP Sender " + message.getHttpMethod())));
            ResponseEntity exchange = this.template.exchange(message.getUrl(), httpMethod, httpEntity, Void.class);
            return exchange.getStatusCode().is2xxSuccessful();
        }
        catch (RestClientException e) {
            log.error("Could not deliver PUSH_OTP message, reason: {}", (Object)e.getMessage());
            return false;
        }
    }

    public ScaMethodTypeBO getType() {
        return ScaMethodTypeBO.PUSH_OTP;
    }

    public PushOtpSender(RestTemplate template) {
        this.template = template;
    }
}

