/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.sender;

import de.adorsys.ledgers.sca.domain.sca.message.MailScaMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;

@Service
public class EmailSender {
    private static final Logger log = LoggerFactory.getLogger(EmailSender.class);
    private final JavaMailSender sender;

    public boolean send(MailScaMessage scaMessage) {
        log.info("Preparing an email to send auth code");
        try {
            SimpleMailMessage message = new SimpleMailMessage();
            message.setTo(scaMessage.getTo());
            message.setFrom(scaMessage.getFrom());
            message.setSubject(scaMessage.getSubject());
            message.setText(scaMessage.getMessage());
            this.sender.send(message);
        }
        catch (MailException e) {
            log.error("Error sending email, No SMTP service configured");
            log.error(e.getMessage());
            return false;
        }
        log.info("Auth code was successfully sent via email");
        return true;
    }

    public EmailSender(JavaMailSender sender) {
        this.sender = sender;
    }
}

