/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.sender;

import de.adorsys.ledgers.sca.domain.sca.message.AppScaMessage;
import de.adorsys.ledgers.sca.service.SCASender;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class AppOtpSender
implements SCASender<AppScaMessage> {
    private static final Logger log = LoggerFactory.getLogger(AppOtpSender.class);
    private final RestTemplate template;

    public boolean send(AppScaMessage message) {
        try {
            HttpMethod method = Optional.ofNullable(HttpMethod.resolve((String)message.getSocketServiceHttpMethod())).orElseThrow(() -> ScaModuleException.buildScaSenderException((String)"Could not parse SocketServiceHttpMethod"));
            HttpEntity httpEntity = new HttpEntity((Object)message);
            ResponseEntity exchange = this.template.exchange(message.getSocketServicePath(), method, httpEntity, Void.class, new Object[0]);
            return exchange.getStatusCode().is2xxSuccessful();
        }
        catch (RestClientException e) {
            log.error("Could not notify TPP-RestServer through REST");
            return false;
        }
    }

    public ScaMethodTypeBO getType() {
        return ScaMethodTypeBO.APP_OTP;
    }

    public AppOtpSender(RestTemplate template) {
        this.template = template;
    }
}

