/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.sca.service.impl.message;

import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.sca.message.MailScaMessage;
import de.adorsys.ledgers.sca.service.impl.message.OtpMessageHandler;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EmailOtpMessageHandler
implements OtpMessageHandler<MailScaMessage> {
    @Value(value="${ledgers.sca.authCode.email.body}")
    private String authCodeEmailBody;
    @Value(value="${ledgers.sca.authCode.email.subject}")
    private String subject;
    @Value(value="${ledgers.sca.authCode.email.from}")
    private String from;

    public ScaMethodTypeBO getType() {
        return ScaMethodTypeBO.EMAIL;
    }

    @Override
    public MailScaMessage getMessage(AuthCodeDataBO data, ScaUserDataBO scaData, String tan) {
        MailScaMessage message = new MailScaMessage();
        message.setFrom(this.from);
        message.setTo(scaData.getMethodValue());
        message.setSubject(this.subject);
        String userMessageTemplate = StringUtils.isBlank((CharSequence)this.authCodeEmailBody) ? data.getUserMessage() : this.authCodeEmailBody;
        message.setMessage(String.format(userMessageTemplate, tan));
        return message;
    }
}

